/*
 * Decompiled with CFR 0.152.
 */
package plus.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import plus.io.Connectable;
import plus.io.ReadWriteable;

final class InetSocket
implements Connectable,
ReadWriteable {
    private final Socket socket;
    private final int timeout;
    private InputStream reader;
    private OutputStream writer;

    InetSocket(Socket sock, int tout) {
        this.socket = sock;
        this.timeout = tout;
    }

    InetSocket(SocketChannel soch, int tout) throws IOException {
        soch.configureBlocking(true);
        this.socket = soch.socket();
        this.timeout = tout;
    }

    @Override
    public void close() throws IOException {
        if (!this.socket.isClosed()) {
            this.socket.close();
        }
    }

    @Override
    public ReadWriteable connect() {
        return this;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.socket.setSoTimeout(this.timeout);
        if (null == this.reader) {
            this.reader = this.socket.getInputStream();
        }
        return this.reader;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (null == this.writer) {
            this.writer = this.socket.getOutputStream();
        }
        return this.writer;
    }
}

