/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.builtin;

import java.math.BigInteger;
import net.morilib.awk.builtin.AwkUnaryArgs;
import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.misc.Math2;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkFloat;
import net.morilib.awk.value.AwkInteger;
import net.morilib.awk.value.AwkValue;

public class AwkSqrt
extends AwkUnaryArgs {
    protected AwkSqrt() {
        super("sqrt");
    }

    public AwkValue apply(AwkNamespace ns, AwkFiles o, AwkValue a1) {
        BigInteger[] q;
        if (a1.isNegativeValue()) {
            return AwkFloat.NaN;
        }
        if (a1.isInteger() && (q = Math2.sqrtExact2(a1.toInteger()))[1].signum() == 0) {
            return AwkInteger.valueOf(q[0]);
        }
        return AwkFloat.valueOf(Math.sqrt(a1.toFloat()));
    }
}

