/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.expr;

import java.math.BigInteger;
import net.morilib.awk.AwkArithmeticException;
import net.morilib.awk.expr.AwkExpression;
import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkFloat;
import net.morilib.awk.value.AwkInteger;
import net.morilib.awk.value.AwkUndefined;
import net.morilib.awk.value.AwkValue;

public class AwkDivider
extends AwkExpression {
    private AwkExpression e1;
    private AwkExpression e2;

    public AwkDivider(AwkExpression e1, AwkExpression e2) {
        this.e1 = e1;
        this.e2 = e2;
    }

    public AwkValue eval(AwkNamespace ns, AwkFiles o) {
        AwkValue r1 = this.e1.eval(ns, o);
        AwkValue r2 = this.e2.eval(ns, o);
        if (r1 instanceof AwkUndefined) {
            return AwkInteger.ZERO;
        }
        if (r2 instanceof AwkUndefined) {
            throw new ArithmeticException();
        }
        if (r1.isFloat() || r2.isFloat()) {
            return AwkFloat.valueOf(r1.toFloat() / r2.toFloat());
        }
        if (r1.isIntegerValue() && r2.isIntegerValue()) {
            try {
                BigInteger e = r1.toInteger();
                BigInteger f = r2.toInteger();
                BigInteger[] a = e.divideAndRemainder(f);
                if (a[1].signum() == 0) {
                    return AwkInteger.valueOf(e.divide(f));
                }
            }
            catch (ArithmeticException z) {
                throw new AwkArithmeticException(z.getMessage());
            }
        }
        return AwkFloat.valueOf(r1.toFloat() / r2.toFloat());
    }
}

