/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.expr;

import java.math.BigInteger;
import net.morilib.awk.expr.AwkExpression;
import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkFloat;
import net.morilib.awk.value.AwkInteger;
import net.morilib.awk.value.AwkUndefined;
import net.morilib.awk.value.AwkValue;

public class AwkPowerOp
extends AwkExpression {
    private BigInteger MI = BigInteger.valueOf(Integer.MAX_VALUE);
    private AwkExpression e1;
    private AwkExpression e2;

    public AwkPowerOp(AwkExpression e1, AwkExpression e2) {
        this.e1 = e1;
        this.e2 = e2;
    }

    public AwkValue eval(AwkNamespace ns, AwkFiles o) {
        AwkValue r1 = this.e1.eval(ns, o);
        AwkValue r2 = this.e2.eval(ns, o);
        if (r1 instanceof AwkUndefined) {
            throw new ArithmeticException();
        }
        if (r2 instanceof AwkUndefined) {
            throw new ArithmeticException();
        }
        if (!r1.isInteger() || !r2.isInteger()) {
            return AwkFloat.valueOf(Math.pow(r1.toFloat(), r2.toFloat()));
        }
        BigInteger f = r2.toInteger();
        if (f.signum() < 0) {
            return AwkFloat.valueOf(Math.pow(r1.toFloat(), f.doubleValue()));
        }
        if (f.signum() == 0) {
            if (r2.toInteger().signum() == 0) {
                throw new ArithmeticException();
            }
            return AwkInteger.ONE;
        }
        if (f.equals(BigInteger.ONE)) {
            return AwkInteger.valueOf(r1.toInteger());
        }
        if (f.compareTo(this.MI) <= 0) {
            return AwkInteger.valueOf(r1.toInteger().pow(f.intValue()));
        }
        throw new ArithmeticException();
    }
}

