/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.io;

import java.io.IOException;
import net.morilib.awk.AwkCastException;
import net.morilib.awk.expr.AwkExpression;
import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.io.AwkReader;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkInteger;
import net.morilib.awk.value.AwkString;
import net.morilib.awk.value.AwkValue;

public class AwkGetline
extends AwkExpression {
    private static final AwkValue ZERO = AwkInteger.ZERO;
    private AwkExpression filename;
    private AwkExpression pipe;
    private String varname;

    public AwkGetline(String varname, AwkExpression filename, AwkExpression pipe) {
        this.varname = varname;
        this.filename = filename;
        this.pipe = pipe;
    }

    public AwkValue eval(AwkNamespace ns, AwkFiles f) {
        AwkReader r = null;
        try {
            if (this.pipe != null) {
                r = f.getReadPipe(this.pipe.eval(ns, f).toString(ns));
            } else if (this.filename == null) {
                r = f.getReader(null);
            } else {
                AwkValue v = this.filename.eval(ns, f);
                if (v.equals(ZERO)) {
                    r = f.getReader(null);
                } else {
                    if (!v.isString()) {
                        throw new AwkCastException("string or 0 required");
                    }
                    r = f.getReader(v.toString(ns));
                }
            }
            String s = r.readRecord(ns.getRS());
            if (s == null) {
                return AwkValue.FALSE;
            }
            if (this.varname != null) {
                ns.assign(this.varname, AwkString.valueOf(s));
                return AwkValue.TRUE;
            }
            ns.setField(s);
            return AwkValue.TRUE;
        }
        catch (IOException e) {
            return AwkValue.IOERROR;
        }
    }
}

