/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.namespace;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.namespace.AwkSimpleNamespace;
import net.morilib.awk.value.AwkInteger;
import net.morilib.awk.value.AwkString;
import net.morilib.awk.value.AwkUndefined;
import net.morilib.awk.value.AwkValue;

public class AwkRootNamespace
extends AwkSimpleNamespace {
    private String line;
    private List<String> fields;

    public AwkValue find(String s) {
        if (s.equals("NF")) {
            return AwkInteger.valueOf(this.fields.size());
        }
        return super.find(s);
    }

    public void assign(String s, AwkValue v) {
        if (!s.equals("NF")) {
            super.assign(s, v);
        }
    }

    public AwkValue referField(int n) {
        if (n < 0) {
            return AwkUndefined.UNDEF;
        }
        if (n == 0) {
            return AwkString.valueOf(this.line);
        }
        if (n <= this.fields.size()) {
            return AwkString.valueOf(this.fields.get(n - 1));
        }
        return AwkUndefined.UNDEF;
    }

    private void _joinField() {
        StringBuffer b = new StringBuffer();
        String ofs = this.getOFS();
        String d = "";
        for (String s : this.fields) {
            b.append(d).append(s);
            d = ofs;
        }
        this.line = b.toString();
    }

    public void setField(int n, String v) {
        if (n >= 0) {
            if (n == 0) {
                this.setField(v);
            } else if (n <= this.fields.size()) {
                this.fields.set(n - 1, v);
                this._joinField();
            } else {
                int i = this.sizeOfField();
                while (i < n - 1) {
                    this.fields.add("");
                    ++i;
                }
                this.fields.add(v);
                this._joinField();
            }
        }
    }

    public int sizeOfField() {
        return this.fields.size();
    }

    void setField(String s, String fs, boolean seq) {
        StringBuffer b = null;
        boolean ws = seq;
        this.line = s;
        this.fields = new ArrayList<String>();
        int i = 0;
        while (i < s.length()) {
            int c = s.codePointAt(i);
            if (ws && fs.indexOf(c) < 0) {
                b = new StringBuffer().appendCodePoint(c);
                ws = false;
            } else if (!ws && fs.indexOf(c) >= 0) {
                this.fields.add(b == null ? "" : b.toString());
                b = null;
                ws = seq;
            } else if (!ws) {
                if (b == null) {
                    b = new StringBuffer();
                }
                b.appendCodePoint(c);
            }
            i += c > 65535 ? 2 : 1;
        }
        if (b != null) {
            this.fields.add(b.toString());
        }
    }

    void setFieldRegex(String s, String re) {
        this.fields = Arrays.asList(s.split(re));
        if (this.fields.size() > 0 && this.fields.get(0).equals("")) {
            this.fields = new ArrayList<String>(this.fields);
            this.fields.remove(0);
        }
        if (this.fields.size() > 0 && this.fields.get(this.fields.size() - 1).equals("")) {
            this.fields = new ArrayList<String>(this.fields);
            this.fields.remove(this.fields.size() - 1);
        }
    }

    public void setField(String s) {
        String rs = this.getFS();
        if (rs.equals("")) {
            this.fields = new ArrayList<String>();
            this.fields.add(s);
        } else if (rs.equals(" ")) {
            this.setField(s, " \t", true);
        } else if (rs.length() == 1) {
            this.setField(s, rs, false);
        } else {
            this.setFieldRegex(s, rs);
        }
    }

    public String getFS() {
        return this.find("FS").toString();
    }

    public String getRS() {
        return this.find("RS").toString();
    }

    public String getOFS() {
        return this.find("OFS").toString();
    }

    public String getORS() {
        return this.find("ORS").toString();
    }

    public AwkNamespace getRoot() {
        return this;
    }

    public boolean isRoot() {
        return true;
    }
}

