/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.builtin;

import java.math.BigInteger;

import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.misc.Math2;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkFloat;
import net.morilib.awk.value.AwkInteger;
import net.morilib.awk.value.AwkValue;

public class AwkSqrt extends AwkUnaryArgs {

	protected AwkSqrt() {
		super("sqrt");
	}

	@Override
	public AwkValue apply(AwkNamespace ns, AwkFiles o, AwkValue a1) {
		BigInteger[] q;

		if(a1.isNegativeValue()) {
			return AwkFloat.NaN;
		} else if(a1.isInteger()) {
			q = Math2.sqrtExact2(a1.toInteger());
			if(q[1].signum() == 0) {
				return AwkInteger.valueOf(q[0]);
			}
		}
		return AwkFloat.valueOf(Math.sqrt(a1.toFloat()));
	}

}
