/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.builtin.s;

import net.morilib.awk.namespace.AwkNamespace;

public class AwkStrBuiltInLoader {

	/**
	 * 
	 * @param ns
	 */
	public static void load(AwkNamespace ns) {
		AwkNamespace ss = ns.subnamespace("s");

		ss.bindFunction("asc",        new SAsc());
		ss.bindFunction("at",         new SAt());
		ss.bindFunction("casecmp",    new SCasecmp());
		ss.bindFunction("caseequals", new SCaseequals());
		ss.bindFunction("checksum",   new SChecksum());
		ss.bindFunction("chomp",      new SChomp());
		ss.bindFunction("chop",       new SChop());
		ss.bindFunction("chr",        new SChr());
		ss.bindFunction("cmp",        new SCmp());
		ss.bindFunction("contains",   new SContains());
		ss.bindFunction("dump",       new SDump());
		ss.bindFunction("ends",       new SEnds());
		ss.bindFunction("insert",     new SInsert());
		ss.bindFunction("join",       new SJoin());
		ss.bindFunction("ltrim",      new SLtrim());
		ss.bindFunction("parseint",   new SParseint());
		ss.bindFunction("reverse",    new SReverse());
		ss.bindFunction("rindex",     new SRindex());
		ss.bindFunction("rtrim",      new SRtrim());
		ss.bindFunction("starts",     new SStarts());
		ss.bindFunction("tolower",    new STolower());
		ss.bindFunction("tostring",   new STostring());
		ss.bindFunction("toupper",    new SToupper());
		ss.bindFunction("tr",         new STr());
		ss.bindFunction("trim",       new STrim());
	}

}
