/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.builtin.t;

import java.util.Calendar;
import java.util.GregorianCalendar;

import net.morilib.awk.builtin.AwkUnaryArgs;
import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkString;
import net.morilib.awk.value.AwkValue;

public class TEra extends AwkUnaryArgs {

	private static final AwkString AD = AwkString.valueOf("AD");
	private static final AwkString BC = AwkString.valueOf("BC");

	protected TEra() {
		super("era");
	}

	@Override
	public AwkValue apply(AwkNamespace ns, AwkFiles o, AwkValue a1) {
		GregorianCalendar c = new GregorianCalendar();

		c.setTimeInMillis(a1.toInteger().longValue());
		switch(c.get(Calendar.ERA)) {
		case 0:   return BC;
		case 1:   return AD;
		default:  throw new RuntimeException();
		}
	}

}
