/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.value;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

import net.morilib.awk.AwkCastException;
import net.morilib.awk.namespace.AwkNamespace;

public class AwkArray extends AwkValue {

	private Map<String, AwkValue> map;

	/**
	 * 
	 */
	public AwkArray() {
//		map = new HashMap<String, AwkValue>();
		map = new TreeMap<String, AwkValue>();
	}

	/**
	 * 
	 * @param o
	 * @param s
	 */
	public AwkArray(int x, String... s) {
		this();
		for(int i = 0; i < s.length; i++) {
			map.put(Integer.toString(i + x), AwkString.valueOf(s[i]));
		}
	}

	/**
	 * 
	 * @param v
	 */
	public AwkArray(AwkValue v) {
		this();
		if(v.isArray()) {
			map.putAll(v.map());
		} else {
			map.put("1", v);
		}
	}

	public boolean isFloat() {
		return false;
	}

	public boolean isInteger() {
		return false;
	}

	public boolean isReal() {
		return false;
	}

	public boolean isFloatValue() {
		return false;
	}

	public boolean isIntegerValue() {
		return false;
	}

	public boolean isRealValue() {
		return false;
	}

	@Override
	public boolean isNegativeValue() {
		return false;
	}

	@Override
	public boolean isPositiveValue() {
		return false;
	}

	@Override
	public boolean isZeroValue() {
		return false;
	}

	public boolean isString() {
		return false;
	}

	public boolean isRegex() {
		return false;
	}

	public boolean isFunction() {
		return false;
	}

	public boolean isArray() {
		return true;
	}

	public boolean toBoolean() {
		for(AwkValue v : values()) {
			if(!v.toBoolean())  return false;
		}
		return true;
	}

	/* (non-Javadoc)
	 * @see net.morilib.awk.value.AwkValue#toObject()
	 */
	public Object toObject() {
		return new TreeMap<String, AwkValue>(map);
	}

	public AwkValue referArray(String v) {
		AwkValue w = map.get(v);

		return w != null ? w : AwkUndefined.UNDEF;
	}

	public AwkValue putArray(String k, AwkValue v) {
		return map.put(k, v);
	}

	public boolean contains(String k) {
		return map.containsKey(k);
	}

	public AwkValue deleteArray(String v) {
		return map.remove(v);
	}

	public Set<String> keys() {
		return map.keySet();
	}

	public Collection<AwkValue> values() {
		return map.values();
	}

	public Set<Map.Entry<String, AwkValue>> entrySet() {
		return map.entrySet();
	}

	public Map<String, AwkValue> map() {
		return Collections.unmodifiableMap(map);
	}

	public int size() {
		return map.size();
	}

	public void clear() {
		map.clear();
	}

	public AwkArray toArray() {
		return this;
	}

	@Override
	public boolean isEmpty() {
//		return map.isEmpty();
		for(AwkValue v : values()) {
			if(!v.isEmpty())  return false;
		}
		return true;
	}

	public int compareTo(AwkValue o, AwkNamespace ns) {
		throw new AwkCastException(this + " is not comparable");
	}

	public int hashCode() {
		return map.hashCode();
	}

	public boolean equals(Object o) {
		if(o instanceof AwkArray) {
			return map.equals(((AwkArray)o).map);
		}
		return false;
	}

	public String toString(AwkNamespace ns) {
		return map.toString();
	}

}
