/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.c.pre.directive;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import net.morilib.c.pre.CpreMacros;
import net.morilib.c.pre.CpreSyntaxException;

public class CpreIfdef implements CpreDirective {

	static final Pattern PI1 =
		Pattern.compile("([A-Za-z_][A-Za-z0-9_]*)[ \t]*");

	public CpreIfState execute(CpreMacros macros, String line,
			int ln, CpreIfState stat) {
		Matcher m = PI1.matcher(line);

		if(!m.matches()) {
			throw new CpreSyntaxException(ln, CpreDefine.ERR001);
		} else if(macros.isDefined(m.group(1))) {
			return CpreIfState.BEGIN;
		} else {
			return CpreIfState.READY;
		}
	}

}
