/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.io;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import net.morilib.awk.io.AwkReader;
import net.morilib.awk.io.AwkVirtualFile;
import net.morilib.awk.io.LineWriter;
import net.morilib.awk.io.PrintLineWriter;
import net.morilib.awk.io.RecordReader;
import net.morilib.awk.misc.System2;

public class AwkFiles {
    private static final String PIPE_ID = "\u0007\u0002";
    private Map<String, RecordReader> readers = new HashMap<String, RecordReader>();
    private Map<String, LineWriter> writers = new HashMap<String, LineWriter>();
    private AwkReader stdin;
    private LineWriter stdout;
    private LineWriter stderr;

    public AwkFiles() {
        this(System.in, System.out, System.err);
    }

    public AwkFiles(Reader stdin, Writer stdout, Writer stderr) {
        this.stdin = new AwkReader(stdin);
        this.stdout = new PrintLineWriter(new PrintWriter(stdout));
        this.stderr = new PrintLineWriter(new PrintWriter(stderr));
    }

    public AwkFiles(InputStream stdin, OutputStream stdout, OutputStream stderr) {
        this(new InputStreamReader(stdin), new OutputStreamWriter(stdout), new OutputStreamWriter(stderr));
    }

    public RecordReader getReader(String filename) throws IOException {
        RecordReader r;
        if (filename == null) {
            r = this.stdin;
        } else {
            r = AwkVirtualFile.in(filename, this);
            if (r == null && (r = this.readers.get(filename)) == null) {
                r = new AwkReader(new InputStreamReader(new FileInputStream(filename)));
                this.readers.put(filename, r);
            }
        }
        return r;
    }

    public RecordReader getReadPipe(String command) throws IOException {
        RecordReader r = this.readers.get(PIPE_ID + command);
        if (r == null) {
            File t = File.createTempFile("awkium", "pipe");
            t.deleteOnExit();
            BufferedOutputStream o = new BufferedOutputStream(new FileOutputStream(t));
            System2.system(command, null, o);
            o.close();
            r = new AwkReader(new InputStreamReader(new FileInputStream(t)));
            this.readers.put(PIPE_ID + command, r);
        }
        return r;
    }

    public LineWriter openWriter(String filename) throws IOException {
        LineWriter r;
        if (filename == null) {
            r = this.stdout;
        } else {
            r = AwkVirtualFile.out(filename, this);
            if (r == null) {
                r = this.writers.get(filename);
                if (r != null) {
                    r.close();
                }
                r = new PrintLineWriter(new PrintWriter(new OutputStreamWriter(new FileOutputStream(filename))));
                this.writers.put(filename, r);
            }
        }
        return r;
    }

    public LineWriter getWriter(String filename) throws IOException {
        LineWriter r;
        if (filename == null) {
            r = this.stdout;
        } else {
            r = AwkVirtualFile.out(filename, this);
            if (r == null && (r = this.writers.get(filename)) == null) {
                r = new PrintLineWriter(new PrintWriter(new OutputStreamWriter(new FileOutputStream(filename))));
                this.writers.put(filename, r);
            }
        }
        return r;
    }

    public LineWriter getStdout() {
        return this.stdout;
    }

    public LineWriter getStderr() {
        return this.stderr;
    }

    public RecordReader getStdin() {
        return this.stdin;
    }

    public void close(String filename) throws IOException {
        Closeable c = this.readers.get(filename);
        if (c != null) {
            c.close();
        } else {
            c = this.writers.get(filename);
            if (c != null) {
                c.close();
            }
        }
    }

    private static void closeq(Closeable c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void closeAll() {
        for (Closeable closeable : this.readers.values()) {
            AwkFiles.closeq(closeable);
        }
        for (Closeable closeable : this.writers.values()) {
            AwkFiles.closeq(closeable);
        }
    }
}

