/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.stat.dist;

import net.morilib.awk.stat.dist.DiscreteDistribution;
import net.morilib.awk.stat.misc.IntTransform;
import net.morilib.awk.stat.misc.MonotonicFunctions;

public abstract class AbstractDiscreteDistribution
implements DiscreteDistribution {
    public final IntTransform cumulative = new IntTransform(){

        public double f(int x) {
            return AbstractDiscreteDistribution.this.cdf(x);
        }
    };

    public double f(double x) {
        if (x >= 0.0 && Math.IEEEremainder(x, 1.0) == 0.0) {
            return this.f((int)x);
        }
        return 0.0;
    }

    public double cdf(double x) {
        double r = 0.0;
        int n = (int)(x > 0.0 ? x : 0.0);
        int i = 0;
        while (i <= n) {
            r += this.f(i);
            ++i;
        }
        return r;
    }

    public double cdf(double x1, double x2) {
        return this.cdf(x2) - this.cdf(x1);
    }

    public double median() {
        int r = this.supportMinimum();
        while (this.cdf(r) < 0.5) {
            ++r;
        }
        return r;
    }

    public int invCdf(double p) {
        if (p == 1.0) {
            return Integer.MAX_VALUE;
        }
        if (p == 0.0) {
            return 0;
        }
        if (0.0 < p && p < 1.0) {
            return MonotonicFunctions.findRootByBisectionMethod(this.cumulative, p, this.supportMinimum(), 0x7FFFFFFE);
        }
        return -1;
    }
}

