/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.c.pre.expr;

import net.morilib.c.pre.CpreMacros;

/**
 * 整数定数です。<br />
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/04/13
 */
public class CpreLiteralInteger extends CpreExpression
implements CpreValue {

	long value;

	/**
	 * 浮動小数定数を生成します。
	 * 
	 * @param f 値
	 */
	public CpreLiteralInteger(long v) {
		value = v;
	}

	public double toFloat() {
		return (double)value;
	}

	public long toLong() {
		return value;
	}

	public int compareTo(CpreValue o) {
		double w;
		long v;

		if(o.isLong()) {
			v = o.toLong();
			return value < v ? -1 : value > v ? 1 : 0;
		} else {
			w = o.toFloat();
			return value < w ? -1 : value > w ? 1 : 0;
		}
	}

	@Override
	public CpreValue eval(int lineno, CpreMacros m) {
		return this;
	}

	public boolean isFloat() {
		return false;
	}

	public boolean isLong() {
		return true;
	}

	public boolean toBoolean() {
		return value != 0;
	}

}
