/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.builtin.rel;

import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkString;

/**
 * パッケージrelの関数を読み込みます。
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/04/13
 */
public class AwkRelBuiltInLoader {

	/**
	 * 
	 * @param ns
	 */
	public static void load(AwkNamespace ns) {
		AwkNamespace ss = ns.subnamespace("rel");

		ns.assign(Relations.TBLSEP, AwkString.valueOf("\u001e"));
		ss.bindFunction("tuple", new RelTuple());
		ss.bindFunction("array", new RelArray());

		ss.bindFunction("project", new RelProjection());
		ss.bindFunction("crossjoin", new RelCrossjoin());
		ss.bindFunction("naturaljoin", new RelNaturaljoin());
		ss.bindFunction("restrict", new RelRestriction());
		ss.bindFunction("select", new RelSelect());
		ss.bindFunction("union", new RelUnion());
		ss.bindFunction("intersect", new RelIntersect());
		ss.bindFunction("except", new RelExcept());
		ss.bindFunction("divide", new RelDivide());
	}

}
