/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.matrix;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2011/09/19
 */
public interface DoubleVector {

	/**
	 * 
	 * @param index
	 * @return
	 */
	public double get(int index);

	/**
	 * 
	 * @param index
	 * @param x
	 * @throws AwkMatrixException
	 */
	public void set(int index,
			double x) throws AwkMatrixException;

	/**
	 * 
	 * @return
	 */
	public int size();

	/**
	 * 
	 * @param x
	 * @return
	 */
	public DoubleVector mul(double x);

	/**
	 * 
	 * @param v
	 * @return
	 */
	public DoubleVector add(DoubleVector v);

	/**
	 * 
	 * @param v
	 * @return
	 */
	public DoubleVector sub(DoubleVector v);

	/**
	 * 
	 * @return
	 */
	public DoubleVector uminus();

	/**
	 * 
	 * @param b
	 * @return
	 * @throws AwkMatrixException
	 */
	public double innerProduct(
			DoubleVector b) throws AwkMatrixException;

	/**
	 * 
	 * @return
	 */
	public double normSquared();

	/**
	 * 
	 * @param y
	 * @return
	 */
	public boolean isEqualTo(DoubleVector y);

}
