/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.stat.dist;

/**
 * 連続確率分布を表すインターフェースです。
 * 
 *
 * @author MORIGUCHI, Yuichiro 2012/02/14
 */
public interface ContinuousDistribution extends Distribution {

	/**
	 * 値が台にあるかを調べます。
	 * 
	 * @param n 値
	 * @return 台にあるときtrue
	 */
	public boolean isInSupport(double n);

	/**
	 * 方程式cdf(x)=pをとき、xを求めます。
	 * 
	 * @param p 値
	 * @return 解
	 */
	public double invCdf(double p);

	/**
	 * 台の上界を返します。
	 * 
	 * @return 上界
	 */
	public double supportSupremum();

	/**
	 * 台の下界を返します。
	 * 
	 * @return 下界
	 */
	public double supportInfimum();

}
