/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.c.pre.directive;

/**
 * 条件付きコンパイルの状態を扱う列挙型です。
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/04/13
 */
public enum CpreIfState {

	/**
	 * 条件付きコンパイルが実行されていない状態です。
	 */
	TOP(true, false, false, true),

	/**
	 * #ifで使用される、条件付きコンパイルを始めた状態です。
	 */
	BEGIN(true, false, false, false),

	/**
	 * #ifで使用される、条件付きコンパイルをしていない状態です。
	 */
	READY(false, false, false, false),

	/**
	 * まだ条件付きコンパイルを実行していない状態です。
	 */
	UNPROCESSED(false, false, false, false),

	/**
	 * 条件付きコンパイルを実行している状態です。
	 */
	PROCESSING(true, false, false, false),

	/**
	 * 条件付きコンパイルを完了した状態です。
	 */
	PROCESSED(false, true, false, false),

	/**
	 * #elseを実行している状態です。
	 */
	PROCESSING_ELSE(true, false, true, false),

	/**
	 * 一連の条件付きコンパイルを完了した状態です。
	 */
	DONE(false, true, true, false),

	/**
	 * 条件付きコンパイルを完了し、スタックポップを指示します。
	 */
	RETURN(false, false, false, false),

	/**
	 * 状態をそのままにすることを指示します。
	 */
	STAY(false, false, false, false);

	private boolean processing, processed, done, topLevel;

	CpreIfState(boolean p, boolean pd, boolean d, boolean t) {
		processing = p;
		processed = pd;
		done = d;
		topLevel = t;
	}

	/**
	 * 条件付きコンパイルを実行しているかを調べます
	 * 
	 * @return 条件付きコンパイルを実行しているときtrue
	 */
	public boolean isProcessing() {
		return processing;
	}

	/**
	 * 条件付きコンパイルを終了したかを調べます
	 * 
	 * @return 条件付きコンパイルを終了したときtrue
	 */
	public boolean isProcessed() {
		return processed;
	}

	/**
	 * 条件付きコンパイルを完了したかを調べます
	 * 
	 * @return 条件付きコンパイルを完了したときtrue
	 */
	public boolean isDone() {
		return done;
	}

	/**
	 * 最初の状態であるかを調べます。
	 * 
	 * @return 最初の状態のときtrue
	 */
	public boolean isTopLevel() {
		return topLevel;
	}

}
