/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.builtin.b;

import java.io.UnsupportedEncodingException;

import net.morilib.awk.AwkRuntimeException;
import net.morilib.awk.builtin.AwkTernaryArgs;
import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.misc.Endianness;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkInteger;
import net.morilib.awk.value.AwkValue;

/**
 * 関数b.ushortatの記述です。
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/04/27
 */
public class BUshortat extends AwkTernaryArgs {

	protected BUshortat() {
		super("ushortat");
	}

	@Override
	public AwkValue apply(AwkNamespace ns, AwkFiles o, AwkValue a1,
			AwkValue a2, AwkValue a3) {
		Endianness e = AwkBBuiltInLoader.endian(a3);
		String s = a1.toString();
		int i = a2.toIntExact();

		if(i < 1) {
			throw new AwkRuntimeException("natural number required");
		} else if(i > s.length() - 1) {
			throw new AwkRuntimeException("index out of bounds");
		} else {
			try {
				return AwkInteger.valueOf(
						e.readuShort(s.getBytes("ISO-8859-1"), i - 1));
			} catch (UnsupportedEncodingException e1) {
				throw new RuntimeException(e1);
			}
		}
	}

}
