/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.builtin.stat;

import java.math.BigInteger;

import net.morilib.awk.builtin.AwkBinaryArgs;
import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.stat.dist.DiscreteDistribution;
import net.morilib.awk.stat.dist.NegativeBinomialDistribution;
import net.morilib.awk.value.AwkUndefined;
import net.morilib.awk.value.AwkValue;

/**
 * 関数stat.rnegativebinomialの記述です。
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/04/13
 */
public class RGeometric extends AwkBinaryArgs {

	protected RGeometric() {
		super("rgeometric");
	}

	@Override
	public AwkValue apply(AwkNamespace ns, AwkFiles o, AwkValue a1,
			AwkValue a2) {
		DiscreteDistribution d;
		AwkValue r;

		try {
			d = new NegativeBinomialDistribution(BigInteger.ONE,
					a1.toFloat());
			if(a2 instanceof AwkUndefined) {
				r = AwkStatUtils.generateRandom(d);
			} else {
				r = AwkStatUtils.generateRandoms(d, a2.toIntExact());
			}
			return r;
		} catch(IllegalArgumentException e) {
			throw new AwkStatisticsException("Illegal parameter");
		}
	}

}
