/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.bytes;

import java.util.List;

/**
 * byteのベクタを得ます。
 * 
 * @author MORIGUCHI, Yuichiro 2010/10/11
 */
public interface ByteVector extends List<Byte>, ByteList {

	/**
	 * 与えられたバイトを右から調べ、最初にマッチした位置を得ます。
	 * 
	 * @param v バイト
	 * @return 位置
	 */
	public int lastIndexOfByte(byte v);

	/**
	 * ByteVectorIteratorを得ます。
	 * 
	 * @return ByteVectorIterator
	 */
	public ByteVectorIterator byteVectorIterator();

	/**
	 * 与えられた位置からのByteVectorIteratorを得ます。
	 * 
	 * @param index 位置
	 * @return ByteVectorIterator
	 */
	public ByteVectorIterator byteVectorIterator(int index);

	/**
	 * 部分ベクタを得ます。
	 * 
	 * @param start 開始位置(その位置を含む)
	 * @param end   終了位置(その位置を含まない)
	 * @return 部分ベクタ
	 */
	public ByteVector subVector(int start, int end);

	/**
	 * 与えられた配列の要素すべてを追加します。
	 * 
	 * @param b 配列
	 * @return 追加されたときtrue
	 */
	public boolean addAllByte(byte[] b);

	/**
	 * 与えられた配列の要素すべてを追加します。
	 * 
	 * @param index 位置
	 * @param b 配列
	 * @return 追加されたときtrue
	 */
	public boolean addAllByte(int index, byte[] b);

}
