/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.c.pre;

/**
 * Cプリプロセッサの例外の基底クラスです。
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/04/13
 */
public class CpreException extends RuntimeException {

	/**
	 * 例外を生成します。
	 */
	public CpreException() {
		super();
	}

	/**
	 * 例外を生成します。
	 * 
	 * @param message メッセージ
	 * @param cause   原因
	 */
	public CpreException(String message, Throwable cause) {
		super(message, cause);
	}

	/**
	 * 例外を生成します。
	 * 
	 * @param message メッセージ
	 */
	public CpreException(String message) {
		super(message);
	}

	/**
	 * 例外を生成します。
	 * 
	 * @param cause   原因
	 */
	public CpreException(Throwable cause) {
		super(cause);
	}

}
