/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.builtin.stat;

import java.util.Collection;
import net.morilib.awk.builtin.AwkTernaryArgs;
import net.morilib.awk.builtin.stat.AwkStatisticsException;
import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.stat.StatisticsUtils;
import net.morilib.awk.stat.dist.TDistribution;
import net.morilib.awk.value.AwkInteger;
import net.morilib.awk.value.AwkValue;

public class T1TestRight
extends AwkTernaryArgs {
    public T1TestRight() {
        super("t1testright");
    }

    public AwkValue apply(AwkNamespace ns, AwkFiles o, AwkValue a1, AwkValue a2, AwkValue a3) {
        double expected = a2.toFloat();
        double significance = a3.toFloat();
        int i = 0;
        if (significance < 0.0 || significance > 1.0) {
            throw new AwkStatisticsException("Invaild significance");
        }
        Collection<AwkValue> c = a1.values();
        double[] obsv = new double[c.size()];
        for (AwkValue a : c) {
            obsv[i++] = a.toFloat();
        }
        int num = obsv.length;
        double mean = StatisticsUtils.mean(obsv);
        double var = StatisticsUtils.variance(obsv);
        double t = (mean - expected) / Math.sqrt(var / (double)num);
        TDistribution tdis = new TDistribution(num - 1);
        double min = tdis.invCdf(1.0 - significance);
        double max = Double.POSITIVE_INFINITY;
        return min < t && t < max ? AwkInteger.ZERO : AwkInteger.ONE;
    }
}

