/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.matrix;

import net.morilib.awk.matrix.AbstractImmutableDoubleMatrix;
import net.morilib.awk.matrix.ArrayDoubleMatrix;
import net.morilib.awk.matrix.DoubleMatrix;

public class LUDecomposedLMatrix
extends AbstractImmutableDoubleMatrix {
    private DoubleMatrix a;

    LUDecomposedLMatrix(DoubleMatrix a) {
        this.a = a;
    }

    public double get(int row, int column) {
        if (row > column) {
            return this.a.get(row, column);
        }
        if (row == column) {
            return 1.0;
        }
        return 0.0;
    }

    public int rowSize() {
        return this.a.rowSize();
    }

    public int columnSize() {
        return this.a.columnSize();
    }

    public double determinant() {
        return 1.0;
    }

    public DoubleMatrix inv() {
        ArrayDoubleMatrix r = new ArrayDoubleMatrix(this);
        int c = 1;
        while (c < this.columnSize()) {
            int i = c;
            while (i < this.rowSize()) {
                int j = i - c;
                double x = 0.0;
                int k = j + 1;
                while (k <= i) {
                    x += r.get(i, k) * this.get(k, j);
                    ++k;
                }
                r.set(i, j, -x);
                ++i;
            }
            ++c;
        }
        return r;
    }
}

