/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.stat.dist;

import net.morilib.awk.stat.DoubleTransform;
import net.morilib.awk.stat.dist.AbstractContinuousDistribution;
import net.morilib.awk.stat.special.Gamma;

public class GammaDistribution
extends AbstractContinuousDistribution {
    double k;
    double theta;
    private final DoubleTransform lningamma;
    private final double lngammak;

    public GammaDistribution(double k, double theta) {
        if (k <= 0.0 || theta <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.k = k;
        this.theta = theta;
        this.lngammak = Gamma.lnGamma(k);
        this.lningamma = Gamma.lnIncompleteGammaLowerFunction(k);
    }

    public static GammaDistribution chiSquared(int k) {
        if (k <= 0) {
            throw new IllegalArgumentException();
        }
        return new GammaDistribution((double)k / 2.0, 2.0);
    }

    public static GammaDistribution erlang(int k, double lambda) {
        if (k <= 0) {
            throw new IllegalArgumentException();
        }
        return new GammaDistribution(k, 1.0 / lambda);
    }

    public double getK() {
        return this.k;
    }

    public double getTheta() {
        return this.theta;
    }

    public double f(double x) {
        if (x < 0.0) {
            return 0.0;
        }
        if (x == 0.0) {
            return this.k == 1.0 ? 1.0 / this.theta : 0.0;
        }
        double r = (this.k - 1.0) * Math.log(x) - x / this.theta;
        return Math.exp(r -= this.k * Math.log(this.theta) + this.lngammak);
    }

    public double cdf(double x) {
        return x > 0.0 ? Math.exp(this.lningamma.f(x / this.theta) - this.lngammak) : 0.0;
    }

    public boolean isInSupport(double n) {
        return n >= 0.0;
    }

    public double supportSupremum() {
        return Double.POSITIVE_INFINITY;
    }

    public double supportInfimum() {
        return 0.0;
    }

    public double expectedValue() {
        return this.k * this.theta;
    }

    public double variance() {
        return this.k * this.theta * this.theta;
    }

    public double mode() {
        return this.k < 1.0 ? 0.0 : (this.k - 1.0) * this.theta;
    }

    public double skewness() {
        return 2.0 / Math.sqrt(this.k);
    }

    public double kurtosis() {
        return 6.0 / this.k;
    }

    public int hashCode() {
        int r = 17;
        r = 37 * (r + (int)Double.doubleToLongBits(this.k));
        r = 37 * (r + (int)Double.doubleToLongBits(this.theta));
        return r;
    }

    public boolean equals(Object o) {
        if (o instanceof GammaDistribution) {
            GammaDistribution n = (GammaDistribution)o;
            return this.k == n.k && this.theta == n.theta;
        }
        return false;
    }
}

