/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.bc;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import net.morilib.bc.BcAssignOp;
import net.morilib.bc.BcIncDec;
import net.morilib.bc.BcLexer;
import net.morilib.bc.BcLogical;
import net.morilib.bc.BcNamespace;
import net.morilib.bc.BcNonterminal;
import net.morilib.bc.BcNumber;
import net.morilib.bc.BcRelop;
import net.morilib.bc.BcSymbol;
import net.morilib.bc.BcSyntaxException;

public class BcExprParser {
    private BcLexer lex;
    private List<Object> stack;
    private int stat = 10000;
    private BcNonterminal gt = null;
    private boolean disp = false;

    public BcExprParser(String s) throws IOException {
        this.lex = new BcLexer(s);
        this.stack = new ArrayList<Object>();
        this.stack.add(10000);
    }

    public BcExprParser(BcLexer lex) {
        this.lex = lex;
        this.stack = new ArrayList<Object>();
        this.stack.add(10000);
    }

    private boolean eqchar(char c) throws IOException {
        if (this.lex.eqchar(c)) {
            this.stack.add(Character.valueOf(c));
            return true;
        }
        return false;
    }

    private boolean equalTo(Object o) throws IOException {
        if (this.lex.equalTo(o)) {
            this.stack.add(o);
            return true;
        }
        return false;
    }

    private boolean isSymbol() throws IOException {
        BcSymbol o = this.lex.getSymbol();
        if (o != null) {
            this.stack.add(o);
            return true;
        }
        return false;
    }

    private boolean isSymbol(String s) throws IOException {
        if (this.lex.isSymbol(s)) {
            this.stack.add(new BcSymbol(s));
            return true;
        }
        return false;
    }

    private boolean isEof() {
        return this.lex.isEof();
    }

    private boolean isNumber() throws IOException {
        BcNumber o = this.lex.getNumber();
        if (o != null) {
            this.stack.add(o);
            return true;
        }
        return false;
    }

    private boolean isRelop() throws IOException {
        BcRelop o = this.lex.getRelop();
        if (o != null) {
            this.stack.add((Object)o);
            return true;
        }
        return false;
    }

    private boolean isAssignop() throws IOException {
        BcAssignOp o = this.lex.getAssignop();
        if (o != null) {
            this.stack.add((Object)o);
            return true;
        }
        return false;
    }

    private Object pop() {
        this.stack.remove(this.stack.size() - 1);
        return this.stack.remove(this.stack.size() - 1);
    }

    private void shift(int n) {
        this.stat = n;
        this.disp = this.gt != null && this.gt.isDisplay();
        this.gt = null;
        this.stack.add(n);
    }

    private void setGoto(BcNonterminal nt) {
        this.stat = (Integer)this.stack.get(this.stack.size() - 1);
        this.gt = nt;
        this.stack.add((Object)this.gt);
    }

    public boolean parseExpression(BcNamespace ns, PrintWriter b) throws IOException {
        ArrayList<Object> sem = new ArrayList<Object>();
        while (true) {
            switch (this.stat) {
                case 10000: {
                    if (this.gt == BcNonterminal.EXPR || this.gt == BcNonterminal.EXPR2) {
                        this.shift(10005);
                        break;
                    }
                    if (this.gt == BcNonterminal.VAR) {
                        this.shift(10072);
                        break;
                    }
                    if (this.eqchar('(')) {
                        this.shift(10010);
                        break;
                    }
                    if (this.equalTo((Object)BcIncDec.INC)) {
                        this.shift(10040);
                        break;
                    }
                    if (this.equalTo((Object)BcIncDec.DEC)) {
                        this.shift(10050);
                        break;
                    }
                    if (this.eqchar('-')) {
                        this.shift(10060);
                        break;
                    }
                    if (this.eqchar('!')) {
                        this.shift(10115);
                        break;
                    }
                    if (this.isSymbol("sizeof")) {
                        this.shift(14000);
                        break;
                    }
                    if (this.isSymbol()) {
                        this.shift(10070);
                        break;
                    }
                    if (this.isNumber()) {
                        this.shift(10125);
                        break;
                    }
                    throw new BcSyntaxException();
                }
                case 10005: {
                    if (this.isEof()) {
                        return this.disp;
                    }
                    if (this.eqchar('^')) {
                        this.shift(10140);
                        break;
                    }
                    if (this.eqchar('/')) {
                        this.shift(10150);
                        break;
                    }
                    if (this.eqchar('*')) {
                        this.shift(10160);
                        break;
                    }
                    if (this.eqchar('%')) {
                        this.shift(10170);
                        break;
                    }
                    if (this.isSymbol("mod")) {
                        this.shift(13000);
                        break;
                    }
                    if (this.eqchar('+')) {
                        this.shift(10180);
                        break;
                    }
                    if (this.eqchar('-')) {
                        this.shift(10190);
                        break;
                    }
                    if (this.isRelop()) {
                        this.shift(10200);
                        break;
                    }
                    if (this.equalTo((Object)BcLogical.AND)) {
                        this.shift(10210);
                        break;
                    }
                    if (this.equalTo((Object)BcLogical.OR)) {
                        this.shift(10220);
                        break;
                    }
                    return this.disp;
                }
                case 10010: {
                    if (this.gt == BcNonterminal.EXPR || this.gt == BcNonterminal.EXPR2) {
                        this.shift(10020);
                        break;
                    }
                    if (this.gt == BcNonterminal.VAR) {
                        this.shift(10072);
                        break;
                    }
                    if (this.eqchar('(')) {
                        this.shift(10010);
                        break;
                    }
                    if (this.equalTo((Object)BcIncDec.INC)) {
                        this.shift(10040);
                        break;
                    }
                    if (this.equalTo((Object)BcIncDec.DEC)) {
                        this.shift(10050);
                        break;
                    }
                    if (this.eqchar('-')) {
                        this.shift(10060);
                        break;
                    }
                    if (this.eqchar('!')) {
                        this.shift(10115);
                        break;
                    }
                    if (this.isSymbol("sizeof")) {
                        this.shift(14000);
                        break;
                    }
                    if (this.isSymbol()) {
                        this.shift(10070);
                        break;
                    }
                    if (this.isNumber()) {
                        this.shift(10125);
                        break;
                    }
                    throw new BcSyntaxException();
                }
                case 10020: {
                    if (this.eqchar(')')) {
                        this.shift(10030);
                        break;
                    }
                    if (this.eqchar('^')) {
                        this.shift(10140);
                        break;
                    }
                    if (this.eqchar('/')) {
                        this.shift(10150);
                        break;
                    }
                    if (this.eqchar('*')) {
                        this.shift(10160);
                        break;
                    }
                    if (this.eqchar('%')) {
                        this.shift(10170);
                        break;
                    }
                    if (this.isSymbol("mod")) {
                        this.shift(13000);
                        break;
                    }
                    if (this.eqchar('+')) {
                        this.shift(10180);
                        break;
                    }
                    if (this.eqchar('-')) {
                        this.shift(10190);
                        break;
                    }
                    if (this.isRelop()) {
                        this.shift(10200);
                        break;
                    }
                    if (this.equalTo((Object)BcLogical.AND)) {
                        this.shift(10210);
                        break;
                    }
                    if (this.equalTo((Object)BcLogical.OR)) {
                        this.shift(10220);
                        break;
                    }
                    throw new BcSyntaxException();
                }
                case 10030: {
                    this.pop();
                    this.pop();
                    this.pop();
                    this.setGoto(BcNonterminal.EXPR);
                    break;
                }
                case 10040: {
                    if (this.gt == BcNonterminal.EXPR || this.gt == BcNonterminal.EXPR2) {
                        this.shift(10045);
                        break;
                    }
                    if (this.gt == BcNonterminal.VAR) {
                        this.shift(10045);
                        break;
                    }
                    if (this.isSymbol()) {
                        this.shift(10070);
                        break;
                    }
                    throw new BcSyntaxException();
                }
                case 10045: {
                    this.pop();
                    this.pop();
                    V0 v1 = (V0)sem.remove(sem.size() - 1);
                    b.format("%s1+%s", v1.toString(), v1.storeToString());
                    this.setGoto(BcNonterminal.EXPR);
                    break;
                }
                case 10050: {
                    if (this.gt == BcNonterminal.VAR) {
                        this.shift(10055);
                        break;
                    }
                    if (this.isSymbol()) {
                        this.shift(10070);
                        break;
                    }
                    throw new BcSyntaxException();
                }
                case 10055: {
                    this.pop();
                    this.pop();
                    V0 v1 = (V0)sem.remove(sem.size() - 1);
                    b.format("%s1-%s", v1.toString(), v1.storeToString());
                    this.setGoto(BcNonterminal.EXPR);
                    break;
                }
                case 10060: {
                    if (this.gt == BcNonterminal.EXPR || this.gt == BcNonterminal.EXPR2) {
                        this.shift(10065);
                        break;
                    }
                    if (this.gt == BcNonterminal.VAR) {
                        this.shift(10072);
                        break;
                    }
                    if (this.eqchar('(')) {
                        this.shift(10010);
                        break;
                    }
                    if (this.equalTo((Object)BcIncDec.INC)) {
                        this.shift(10040);
                        break;
                    }
                    if (this.equalTo((Object)BcIncDec.DEC)) {
                        this.shift(10050);
                        break;
                    }
                    if (this.eqchar('!')) {
                        this.shift(10115);
                        break;
                    }
                    if (this.isSymbol("sizeof")) {
                        this.shift(14000);
                        break;
                    }
                    if (this.isSymbol()) {
                        this.shift(10070);
                        break;
                    }
                    if (this.isNumber()) {
                        this.shift(10125);
                        break;
                    }
                    throw new BcSyntaxException();
                }
                case 10065: {
                    this.pop();
                    this.pop();
                    b.append("0r-");
                    this.setGoto(BcNonterminal.EXPR);
                    break;
                }
                case 10070: {
                    if (this.eqchar('(')) {
                        sem.add(0);
                        this.shift(10085);
                        break;
                    }
                    if (this.eqchar('[')) {
                        this.shift(10100);
                        break;
                    }
                    sem.add(new VS(ns.getCharacter(((BcSymbol)this.pop()).toString())));
                    this.setGoto(BcNonterminal.VAR);
                    break;
                }
                case 10072: {
                    if (this.isAssignop()) {
                        this.shift(10074);
                        break;
                    }
                    if (this.equalTo((Object)BcIncDec.INC)) {
                        this.shift(10076);
                        break;
                    }
                    if (this.equalTo((Object)BcIncDec.DEC)) {
                        this.shift(10078);
                        break;
                    }
                    this.pop();
                    String s1 = sem.remove(sem.size() - 1).toString();
                    b.print(s1);
                    this.setGoto(BcNonterminal.EXPR);
                    break;
                }
                case 10074: {
                    if (this.gt == BcNonterminal.EXPR || this.gt == BcNonterminal.EXPR2) {
                        this.shift(10080);
                        break;
                    }
                    if (this.gt == BcNonterminal.VAR) {
                        this.shift(10072);
                        break;
                    }
                    if (this.eqchar('(')) {
                        this.shift(10010);
                        break;
                    }
                    if (this.equalTo((Object)BcIncDec.INC)) {
                        this.shift(10040);
                        break;
                    }
                    if (this.equalTo((Object)BcIncDec.DEC)) {
                        this.shift(10050);
                        break;
                    }
                    if (this.eqchar('-')) {
                        this.shift(10060);
                        break;
                    }
                    if (this.eqchar('!')) {
                        this.shift(10115);
                        break;
                    }
                    if (this.isSymbol("sizeof")) {
                        this.shift(14000);
                        break;
                    }
                    if (this.isSymbol()) {
                        this.shift(10070);
                        break;
                    }
                    if (this.isNumber()) {
                        this.shift(10125);
                        break;
                    }
                    throw new BcSyntaxException();
                }
                case 10076: {
                    this.pop();
                    this.pop();
                    V0 v1 = (V0)sem.remove(sem.size() - 1);
                    b.format("%sd1+%s\u6368", v1.toString(), v1.storeToString());
                    this.setGoto(BcNonterminal.EXPR);
                    break;
                }
                case 10078: {
                    this.pop();
                    this.pop();
                    V0 v1 = (V0)sem.remove(sem.size() - 1);
                    b.format("%sd1-%s\u6368", v1.toString(), v1.storeToString());
                    this.setGoto(BcNonterminal.EXPR);
                    break;
                }
                case 10080: {
                    if (this.eqchar('^')) {
                        this.shift(10140);
                        break;
                    }
                    if (this.eqchar('/')) {
                        this.shift(10150);
                        break;
                    }
                    if (this.eqchar('*')) {
                        this.shift(10160);
                        break;
                    }
                    if (this.eqchar('%')) {
                        this.shift(10170);
                        break;
                    }
                    if (this.isSymbol("mod")) {
                        this.shift(13000);
                        break;
                    }
                    if (this.eqchar('+')) {
                        this.shift(10180);
                        break;
                    }
                    if (this.eqchar('-')) {
                        this.shift(10190);
                        break;
                    }
                    if (this.isRelop()) {
                        this.shift(10200);
                        break;
                    }
                    if (this.equalTo((Object)BcLogical.AND)) {
                        this.shift(10210);
                        break;
                    }
                    if (this.equalTo((Object)BcLogical.OR)) {
                        this.shift(10220);
                        break;
                    }
                    this.pop();
                    BcAssignOp a1 = (BcAssignOp)((Object)this.pop());
                    this.pop();
                    V0 v1 = (V0)sem.remove(sem.size() - 1);
                    if (a1.isSimple()) {
                        b.print(v1.storeToString());
                    } else {
                        b.print(v1.storeopToString(a1.getOperation()));
                    }
                    this.setGoto(BcNonterminal.EXPR2);
                    break;
                }
                case 10085: {
                    if (this.gt == BcNonterminal.EXPR || this.gt == BcNonterminal.EXPR2) {
                        this.shift(11000);
                        break;
                    }
                    if (this.gt == BcNonterminal.VAR) {
                        this.shift(10072);
                        break;
                    }
                    if (this.gt == BcNonterminal.LIST) {
                        this.shift(11010);
                        break;
                    }
                    if (this.eqchar('(')) {
                        this.shift(10010);
                        break;
                    }
                    if (this.equalTo((Object)BcIncDec.INC)) {
                        this.shift(10040);
                        break;
                    }
                    if (this.equalTo((Object)BcIncDec.DEC)) {
                        this.shift(10050);
                        break;
                    }
                    if (this.eqchar('-')) {
                        this.shift(10060);
                        break;
                    }
                    if (this.eqchar('!')) {
                        this.shift(10115);
                        break;
                    }
                    if (this.isSymbol("sizeof")) {
                        this.shift(14000);
                        break;
                    }
                    if (this.isSymbol()) {
                        this.shift(10070);
                        break;
                    }
                    if (this.isNumber()) {
                        this.shift(10125);
                        break;
                    }
                    if (this.eqchar(')')) {
                        this.stack.add(null);
                        this.stack.add(null);
                        this.shift(11020);
                        break;
                    }
                    throw new BcSyntaxException();
                }
                case 11000: {
                    if (this.eqchar('^')) {
                        this.shift(10140);
                        break;
                    }
                    if (this.eqchar('/')) {
                        this.shift(10150);
                        break;
                    }
                    if (this.eqchar('*')) {
                        this.shift(10160);
                        break;
                    }
                    if (this.eqchar('%')) {
                        this.shift(10170);
                        break;
                    }
                    if (this.isSymbol("mod")) {
                        this.shift(13000);
                        break;
                    }
                    if (this.eqchar('+')) {
                        this.shift(10180);
                        break;
                    }
                    if (this.eqchar('-')) {
                        this.shift(10190);
                        break;
                    }
                    if (this.isRelop()) {
                        this.shift(10200);
                        break;
                    }
                    if (this.equalTo((Object)BcLogical.AND)) {
                        this.shift(10210);
                        break;
                    }
                    if (this.equalTo((Object)BcLogical.OR)) {
                        this.shift(10220);
                        break;
                    }
                    this.pop();
                    sem.set(sem.size() - 1, 1);
                    this.setGoto(BcNonterminal.LIST);
                    break;
                }
                case 11010: {
                    if (this.eqchar(')')) {
                        this.shift(11020);
                        break;
                    }
                    if (this.eqchar(',')) {
                        this.shift(11030);
                        break;
                    }
                    throw new BcSyntaxException();
                }
                case 11020: {
                    this.pop();
                    this.pop();
                    this.pop();
                    BcSymbol y1 = (BcSymbol)this.pop();
                    int i1 = (Integer)sem.remove(sem.size() - 1);
                    if (y1.toString().equals("sqrt")) {
                        if (i1 != 1) {
                            throw new BcSyntaxException();
                        }
                        b.print('v');
                    } else if (y1.toString().equals("length")) {
                        if (i1 != 1) {
                            throw new BcSyntaxException();
                        }
                        b.print('Z');
                    } else if (y1.toString().equals("scale")) {
                        if (i1 != 1) {
                            throw new BcSyntaxException();
                        }
                        b.print('X');
                    } else if (y1.toString().equals("tentothe")) {
                        if (i1 != 1) {
                            throw new BcSyntaxException();
                        }
                        b.print('\u4e07');
                    } else if (y1.toString().equals("irr")) {
                        b.format("%d\u5229", i1);
                    } else {
                        int i2 = ns.getArity(y1.toString());
                        if (i2 >= 0) {
                            if (!ns.isVarargs(y1.toString()) && i1 != i2) {
                                throw new BcSyntaxException();
                            }
                            if (ns.isVarargs(y1.toString()) && i1 < i2) {
                                throw new BcSyntaxException();
                            }
                            b.format("%d l%cx", i1, Character.valueOf(ns.getFunction(y1.toString())));
                        }
                    }
                    this.setGoto(BcNonterminal.EXPR);
                    break;
                }
                case 11030: {
                    if (this.gt == BcNonterminal.EXPR || this.gt == BcNonterminal.EXPR2) {
                        this.shift(11040);
                        break;
                    }
                    if (this.gt == BcNonterminal.VAR) {
                        this.shift(10072);
                        break;
                    }
                    if (this.eqchar('(')) {
                        this.shift(10010);
                        break;
                    }
                    if (this.equalTo((Object)BcIncDec.INC)) {
                        this.shift(10040);
                        break;
                    }
                    if (this.equalTo((Object)BcIncDec.DEC)) {
                        this.shift(10050);
                        break;
                    }
                    if (this.eqchar('-')) {
                        this.shift(10060);
                        break;
                    }
                    if (this.eqchar('!')) {
                        this.shift(10115);
                        break;
                    }
                    if (this.isSymbol("sizeof")) {
                        this.shift(14000);
                        break;
                    }
                    if (this.isSymbol()) {
                        this.shift(10070);
                        break;
                    }
                    if (this.isNumber()) {
                        this.shift(10125);
                        break;
                    }
                    throw new BcSyntaxException();
                }
                case 11040: {
                    if (this.eqchar('^')) {
                        this.shift(10140);
                        break;
                    }
                    if (this.eqchar('/')) {
                        this.shift(10150);
                        break;
                    }
                    if (this.eqchar('*')) {
                        this.shift(10160);
                        break;
                    }
                    if (this.eqchar('%')) {
                        this.shift(10170);
                        break;
                    }
                    if (this.isSymbol("mod")) {
                        this.shift(13000);
                        break;
                    }
                    if (this.eqchar('+')) {
                        this.shift(10180);
                        break;
                    }
                    if (this.eqchar('-')) {
                        this.shift(10190);
                        break;
                    }
                    if (this.isRelop()) {
                        this.shift(10200);
                        break;
                    }
                    if (this.equalTo((Object)BcLogical.AND)) {
                        this.shift(10210);
                        break;
                    }
                    if (this.equalTo((Object)BcLogical.OR)) {
                        this.shift(10220);
                        break;
                    }
                    this.pop();
                    this.pop();
                    this.pop();
                    int i1 = (Integer)sem.get(sem.size() - 1);
                    sem.set(sem.size() - 1, i1 + 1);
                    this.setGoto(BcNonterminal.LIST);
                    break;
                }
                case 10100: {
                    if (this.gt == BcNonterminal.EXPR || this.gt == BcNonterminal.EXPR2) {
                        this.shift(10105);
                        break;
                    }
                    if (this.gt == BcNonterminal.VAR) {
                        this.shift(10072);
                        break;
                    }
                    if (this.eqchar('(')) {
                        this.shift(10010);
                        break;
                    }
                    if (this.equalTo((Object)BcIncDec.INC)) {
                        this.shift(10040);
                        break;
                    }
                    if (this.equalTo((Object)BcIncDec.DEC)) {
                        this.shift(10050);
                        break;
                    }
                    if (this.eqchar('-')) {
                        this.shift(10060);
                        break;
                    }
                    if (this.eqchar('!')) {
                        this.shift(10115);
                        break;
                    }
                    if (this.isSymbol("sizeof")) {
                        this.shift(14000);
                        break;
                    }
                    if (this.isSymbol()) {
                        this.shift(10070);
                        break;
                    }
                    if (this.isNumber()) {
                        this.shift(10125);
                        break;
                    }
                    throw new BcSyntaxException();
                }
                case 10105: {
                    if (this.eqchar(']')) {
                        this.shift(10110);
                        break;
                    }
                    if (this.eqchar('^')) {
                        this.shift(10140);
                        break;
                    }
                    if (this.eqchar('/')) {
                        this.shift(10150);
                        break;
                    }
                    if (this.eqchar('*')) {
                        this.shift(10160);
                        break;
                    }
                    if (this.eqchar('%')) {
                        this.shift(10170);
                        break;
                    }
                    if (this.isSymbol("mod")) {
                        this.shift(13000);
                        break;
                    }
                    if (this.eqchar('+')) {
                        this.shift(10180);
                        break;
                    }
                    if (this.eqchar('-')) {
                        this.shift(10190);
                        break;
                    }
                    if (this.isRelop()) {
                        this.shift(10200);
                        break;
                    }
                    if (this.equalTo((Object)BcLogical.AND)) {
                        this.shift(10210);
                        break;
                    }
                    if (this.equalTo((Object)BcLogical.OR)) {
                        this.shift(10220);
                        break;
                    }
                    throw new BcSyntaxException();
                }
                case 10110: {
                    this.pop();
                    this.pop();
                    this.pop();
                    sem.add(new VA(ns.getCharacter(((BcSymbol)this.pop()).toString())));
                    this.setGoto(BcNonterminal.VAR);
                    break;
                }
                case 10115: {
                    if (this.gt == BcNonterminal.EXPR || this.gt == BcNonterminal.EXPR2) {
                        this.shift(10120);
                        break;
                    }
                    if (this.gt == BcNonterminal.VAR) {
                        this.shift(10072);
                        break;
                    }
                    if (this.eqchar('(')) {
                        this.shift(10010);
                        break;
                    }
                    if (this.equalTo((Object)BcIncDec.INC)) {
                        this.shift(10040);
                        break;
                    }
                    if (this.equalTo((Object)BcIncDec.DEC)) {
                        this.shift(10050);
                        break;
                    }
                    if (this.eqchar('-')) {
                        this.shift(10060);
                        break;
                    }
                    if (this.eqchar('!')) {
                        this.shift(10115);
                        break;
                    }
                    if (this.isSymbol("sizeof")) {
                        this.shift(14000);
                        break;
                    }
                    if (this.isSymbol()) {
                        this.shift(10070);
                        break;
                    }
                    if (this.isNumber()) {
                        this.shift(10125);
                        break;
                    }
                    throw new BcSyntaxException();
                }
                case 10120: {
                    if (this.eqchar('^')) {
                        this.shift(10140);
                        break;
                    }
                    if (this.eqchar('/')) {
                        this.shift(10150);
                        break;
                    }
                    if (this.eqchar('*')) {
                        this.shift(10160);
                        break;
                    }
                    if (this.eqchar('%')) {
                        this.shift(10170);
                        break;
                    }
                    if (this.isSymbol("mod")) {
                        this.shift(13000);
                        break;
                    }
                    if (this.eqchar('+')) {
                        this.shift(10180);
                        break;
                    }
                    if (this.eqchar('-')) {
                        this.shift(10190);
                        break;
                    }
                    if (this.isRelop()) {
                        this.shift(10200);
                        break;
                    }
                    this.pop();
                    this.pop();
                    b.append("N");
                    this.setGoto(BcNonterminal.EXPR);
                    break;
                }
                case 10125: {
                    BcNumber n1 = (BcNumber)this.pop();
                    b.append(n1.toString()).append(' ');
                    this.setGoto(BcNonterminal.EXPR);
                    break;
                }
                case 10140: {
                    if (this.gt == BcNonterminal.EXPR || this.gt == BcNonterminal.EXPR2) {
                        this.shift(10145);
                        break;
                    }
                    if (this.gt == BcNonterminal.VAR) {
                        this.shift(10072);
                        break;
                    }
                    if (this.eqchar('(')) {
                        this.shift(10010);
                        break;
                    }
                    if (this.equalTo((Object)BcIncDec.INC)) {
                        this.shift(10040);
                        break;
                    }
                    if (this.equalTo((Object)BcIncDec.DEC)) {
                        this.shift(10050);
                        break;
                    }
                    if (this.eqchar('-')) {
                        this.shift(10060);
                        break;
                    }
                    if (this.eqchar('!')) {
                        this.shift(10115);
                        break;
                    }
                    if (this.isSymbol("sizeof")) {
                        this.shift(14000);
                        break;
                    }
                    if (this.isSymbol()) {
                        this.shift(10070);
                        break;
                    }
                    if (this.isNumber()) {
                        this.shift(10125);
                        break;
                    }
                    throw new BcSyntaxException();
                }
                case 10145: {
                    if (this.eqchar('^')) {
                        this.shift(10140);
                        break;
                    }
                    this.pop();
                    this.pop();
                    this.pop();
                    b.append("^");
                    this.setGoto(BcNonterminal.EXPR);
                    break;
                }
                case 10150: {
                    if (this.gt == BcNonterminal.EXPR || this.gt == BcNonterminal.EXPR2) {
                        this.shift(10155);
                        break;
                    }
                    if (this.gt == BcNonterminal.VAR) {
                        this.shift(10072);
                        break;
                    }
                    if (this.eqchar('(')) {
                        this.shift(10010);
                        break;
                    }
                    if (this.equalTo((Object)BcIncDec.INC)) {
                        this.shift(10040);
                        break;
                    }
                    if (this.equalTo((Object)BcIncDec.DEC)) {
                        this.shift(10050);
                        break;
                    }
                    if (this.eqchar('-')) {
                        this.shift(10060);
                        break;
                    }
                    if (this.eqchar('!')) {
                        this.shift(10115);
                        break;
                    }
                    if (this.isSymbol("sizeof")) {
                        this.shift(14000);
                        break;
                    }
                    if (this.isSymbol()) {
                        this.shift(10070);
                        break;
                    }
                    if (this.isNumber()) {
                        this.shift(10125);
                        break;
                    }
                    throw new BcSyntaxException();
                }
                case 10155: {
                    if (this.eqchar('^')) {
                        this.shift(10140);
                        break;
                    }
                    this.pop();
                    this.pop();
                    this.pop();
                    b.append("/");
                    this.setGoto(BcNonterminal.EXPR);
                    break;
                }
                case 10160: {
                    if (this.gt == BcNonterminal.EXPR || this.gt == BcNonterminal.EXPR2) {
                        this.shift(10165);
                        break;
                    }
                    if (this.gt == BcNonterminal.VAR) {
                        this.shift(10072);
                        break;
                    }
                    if (this.eqchar('(')) {
                        this.shift(10010);
                        break;
                    }
                    if (this.equalTo((Object)BcIncDec.INC)) {
                        this.shift(10040);
                        break;
                    }
                    if (this.equalTo((Object)BcIncDec.DEC)) {
                        this.shift(10050);
                        break;
                    }
                    if (this.eqchar('-')) {
                        this.shift(10060);
                        break;
                    }
                    if (this.eqchar('!')) {
                        this.shift(10115);
                        break;
                    }
                    if (this.isSymbol("sizeof")) {
                        this.shift(14000);
                        break;
                    }
                    if (this.isSymbol()) {
                        this.shift(10070);
                        break;
                    }
                    if (this.isNumber()) {
                        this.shift(10125);
                        break;
                    }
                    throw new BcSyntaxException();
                }
                case 10165: {
                    if (this.eqchar('^')) {
                        this.shift(10140);
                        break;
                    }
                    this.pop();
                    this.pop();
                    this.pop();
                    b.append("*");
                    this.setGoto(BcNonterminal.EXPR);
                    break;
                }
                case 10170: {
                    if (this.gt == BcNonterminal.EXPR || this.gt == BcNonterminal.EXPR2) {
                        this.shift(10175);
                        break;
                    }
                    if (this.gt == BcNonterminal.VAR) {
                        this.shift(10072);
                        break;
                    }
                    if (this.eqchar('(')) {
                        this.shift(10010);
                        break;
                    }
                    if (this.equalTo((Object)BcIncDec.INC)) {
                        this.shift(10040);
                        break;
                    }
                    if (this.equalTo((Object)BcIncDec.DEC)) {
                        this.shift(10050);
                        break;
                    }
                    if (this.eqchar('-')) {
                        this.shift(10060);
                        break;
                    }
                    if (this.eqchar('!')) {
                        this.shift(10115);
                        break;
                    }
                    if (this.isSymbol("sizeof")) {
                        this.shift(14000);
                        break;
                    }
                    if (this.isSymbol()) {
                        this.shift(10070);
                        break;
                    }
                    if (this.isNumber()) {
                        this.shift(10125);
                        break;
                    }
                    throw new BcSyntaxException();
                }
                case 10175: {
                    if (this.eqchar('^')) {
                        this.shift(10140);
                        break;
                    }
                    this.pop();
                    this.pop();
                    this.pop();
                    b.append("%");
                    this.setGoto(BcNonterminal.EXPR);
                    break;
                }
                case 13000: {
                    if (this.gt == BcNonterminal.EXPR || this.gt == BcNonterminal.EXPR2) {
                        this.shift(13010);
                        break;
                    }
                    if (this.gt == BcNonterminal.VAR) {
                        this.shift(10072);
                        break;
                    }
                    if (this.eqchar('(')) {
                        this.shift(10010);
                        break;
                    }
                    if (this.equalTo((Object)BcIncDec.INC)) {
                        this.shift(10040);
                        break;
                    }
                    if (this.equalTo((Object)BcIncDec.DEC)) {
                        this.shift(10050);
                        break;
                    }
                    if (this.eqchar('-')) {
                        this.shift(10060);
                        break;
                    }
                    if (this.eqchar('!')) {
                        this.shift(10115);
                        break;
                    }
                    if (this.isSymbol("sizeof")) {
                        this.shift(14000);
                        break;
                    }
                    if (this.isSymbol()) {
                        this.shift(10070);
                        break;
                    }
                    if (this.isNumber()) {
                        this.shift(10125);
                        break;
                    }
                    throw new BcSyntaxException();
                }
                case 13010: {
                    if (this.eqchar('^')) {
                        this.shift(10140);
                        break;
                    }
                    this.pop();
                    this.pop();
                    this.pop();
                    b.append("\u6cd5");
                    this.setGoto(BcNonterminal.EXPR);
                    break;
                }
                case 10180: {
                    if (this.gt == BcNonterminal.EXPR || this.gt == BcNonterminal.EXPR2) {
                        this.shift(10185);
                        break;
                    }
                    if (this.gt == BcNonterminal.VAR) {
                        this.shift(10072);
                        break;
                    }
                    if (this.eqchar('(')) {
                        this.shift(10010);
                        break;
                    }
                    if (this.equalTo((Object)BcIncDec.INC)) {
                        this.shift(10040);
                        break;
                    }
                    if (this.equalTo((Object)BcIncDec.DEC)) {
                        this.shift(10050);
                        break;
                    }
                    if (this.eqchar('-')) {
                        this.shift(10060);
                        break;
                    }
                    if (this.eqchar('!')) {
                        this.shift(10115);
                        break;
                    }
                    if (this.isSymbol("sizeof")) {
                        this.shift(14000);
                        break;
                    }
                    if (this.isSymbol()) {
                        this.shift(10070);
                        break;
                    }
                    if (this.isNumber()) {
                        this.shift(10125);
                        break;
                    }
                    throw new BcSyntaxException();
                }
                case 10185: {
                    if (this.eqchar('^')) {
                        this.shift(10140);
                        break;
                    }
                    if (this.eqchar('/')) {
                        this.shift(10150);
                        break;
                    }
                    if (this.eqchar('*')) {
                        this.shift(10160);
                        break;
                    }
                    if (this.eqchar('%')) {
                        this.shift(10170);
                        break;
                    }
                    if (this.isSymbol("mod")) {
                        this.shift(13000);
                        break;
                    }
                    this.pop();
                    this.pop();
                    this.pop();
                    b.append("+");
                    this.setGoto(BcNonterminal.EXPR);
                    break;
                }
                case 10190: {
                    if (this.gt == BcNonterminal.EXPR || this.gt == BcNonterminal.EXPR2) {
                        this.shift(10195);
                        break;
                    }
                    if (this.gt == BcNonterminal.VAR) {
                        this.shift(10072);
                        break;
                    }
                    if (this.eqchar('(')) {
                        this.shift(10010);
                        break;
                    }
                    if (this.equalTo((Object)BcIncDec.INC)) {
                        this.shift(10040);
                        break;
                    }
                    if (this.equalTo((Object)BcIncDec.DEC)) {
                        this.shift(10050);
                        break;
                    }
                    if (this.eqchar('-')) {
                        this.shift(10060);
                        break;
                    }
                    if (this.eqchar('!')) {
                        this.shift(10115);
                        break;
                    }
                    if (this.isSymbol("sizeof")) {
                        this.shift(14000);
                        break;
                    }
                    if (this.isSymbol()) {
                        this.shift(10070);
                        break;
                    }
                    if (this.isNumber()) {
                        this.shift(10125);
                        break;
                    }
                    throw new BcSyntaxException();
                }
                case 10195: {
                    if (this.eqchar('^')) {
                        this.shift(10140);
                        break;
                    }
                    if (this.eqchar('/')) {
                        this.shift(10150);
                        break;
                    }
                    if (this.eqchar('*')) {
                        this.shift(10160);
                        break;
                    }
                    if (this.eqchar('%')) {
                        this.shift(10170);
                        break;
                    }
                    if (this.isSymbol("mod")) {
                        this.shift(13000);
                        break;
                    }
                    this.pop();
                    this.pop();
                    this.pop();
                    b.append("-");
                    this.setGoto(BcNonterminal.EXPR);
                    break;
                }
                case 10200: {
                    if (this.gt == BcNonterminal.EXPR || this.gt == BcNonterminal.EXPR2) {
                        this.shift(10205);
                        break;
                    }
                    if (this.gt == BcNonterminal.VAR) {
                        this.shift(10072);
                        break;
                    }
                    if (this.eqchar('(')) {
                        this.shift(10010);
                        break;
                    }
                    if (this.equalTo((Object)BcIncDec.INC)) {
                        this.shift(10040);
                        break;
                    }
                    if (this.equalTo((Object)BcIncDec.DEC)) {
                        this.shift(10050);
                        break;
                    }
                    if (this.eqchar('-')) {
                        this.shift(10060);
                        break;
                    }
                    if (this.eqchar('!')) {
                        this.shift(10115);
                        break;
                    }
                    if (this.isSymbol("sizeof")) {
                        this.shift(14000);
                        break;
                    }
                    if (this.isSymbol()) {
                        this.shift(10070);
                        break;
                    }
                    if (this.isNumber()) {
                        this.shift(10125);
                        break;
                    }
                    throw new BcSyntaxException();
                }
                case 10205: {
                    if (this.eqchar('^')) {
                        this.shift(10140);
                        break;
                    }
                    if (this.eqchar('/')) {
                        this.shift(10150);
                        break;
                    }
                    if (this.eqchar('*')) {
                        this.shift(10160);
                        break;
                    }
                    if (this.eqchar('%')) {
                        this.shift(10170);
                        break;
                    }
                    if (this.isSymbol("mod")) {
                        this.shift(13000);
                        break;
                    }
                    if (this.eqchar('+')) {
                        this.shift(10180);
                        break;
                    }
                    if (this.eqchar('-')) {
                        this.shift(10190);
                        break;
                    }
                    this.pop();
                    b.append(((BcRelop)((Object)this.pop())).getCommand());
                    this.pop();
                    this.setGoto(BcNonterminal.EXPR);
                    break;
                }
                case 10210: {
                    if (this.gt == BcNonterminal.EXPR || this.gt == BcNonterminal.EXPR2) {
                        this.shift(10215);
                        break;
                    }
                    if (this.gt == BcNonterminal.VAR) {
                        this.shift(10072);
                        break;
                    }
                    if (this.eqchar('(')) {
                        this.shift(10010);
                        break;
                    }
                    if (this.equalTo((Object)BcIncDec.INC)) {
                        this.shift(10040);
                        break;
                    }
                    if (this.equalTo((Object)BcIncDec.DEC)) {
                        this.shift(10050);
                        break;
                    }
                    if (this.eqchar('-')) {
                        this.shift(10060);
                        break;
                    }
                    if (this.eqchar('!')) {
                        this.shift(10115);
                        break;
                    }
                    if (this.isSymbol("sizeof")) {
                        this.shift(14000);
                        break;
                    }
                    if (this.isSymbol()) {
                        this.shift(10070);
                        break;
                    }
                    if (this.isNumber()) {
                        this.shift(10125);
                        break;
                    }
                    throw new BcSyntaxException();
                }
                case 10215: {
                    if (this.eqchar('^')) {
                        this.shift(10140);
                        break;
                    }
                    if (this.eqchar('/')) {
                        this.shift(10150);
                        break;
                    }
                    if (this.eqchar('*')) {
                        this.shift(10160);
                        break;
                    }
                    if (this.eqchar('%')) {
                        this.shift(10170);
                        break;
                    }
                    if (this.isSymbol("mod")) {
                        this.shift(13000);
                        break;
                    }
                    if (this.eqchar('+')) {
                        this.shift(10180);
                        break;
                    }
                    if (this.eqchar('-')) {
                        this.shift(10190);
                        break;
                    }
                    if (this.isRelop()) {
                        this.shift(10200);
                        break;
                    }
                    this.pop();
                    this.pop();
                    this.pop();
                    b.append("\uff06");
                    this.setGoto(BcNonterminal.EXPR);
                    break;
                }
                case 10220: {
                    if (this.gt == BcNonterminal.EXPR || this.gt == BcNonterminal.EXPR2) {
                        this.shift(10225);
                        break;
                    }
                    if (this.gt == BcNonterminal.VAR) {
                        this.shift(10072);
                        break;
                    }
                    if (this.eqchar('(')) {
                        this.shift(10010);
                        break;
                    }
                    if (this.equalTo((Object)BcIncDec.INC)) {
                        this.shift(10040);
                        break;
                    }
                    if (this.equalTo((Object)BcIncDec.DEC)) {
                        this.shift(10050);
                        break;
                    }
                    if (this.eqchar('-')) {
                        this.shift(10060);
                        break;
                    }
                    if (this.eqchar('!')) {
                        this.shift(10115);
                        break;
                    }
                    if (this.isSymbol("sizeof")) {
                        this.shift(14000);
                        break;
                    }
                    if (this.isSymbol()) {
                        this.shift(10070);
                        break;
                    }
                    if (this.isNumber()) {
                        this.shift(10125);
                        break;
                    }
                    throw new BcSyntaxException();
                }
                case 10225: {
                    if (this.eqchar('^')) {
                        this.shift(10140);
                        break;
                    }
                    if (this.eqchar('/')) {
                        this.shift(10150);
                        break;
                    }
                    if (this.eqchar('*')) {
                        this.shift(10160);
                        break;
                    }
                    if (this.eqchar('%')) {
                        this.shift(10170);
                        break;
                    }
                    if (this.isSymbol("mod")) {
                        this.shift(13000);
                        break;
                    }
                    if (this.eqchar('+')) {
                        this.shift(10180);
                        break;
                    }
                    if (this.eqchar('-')) {
                        this.shift(10190);
                        break;
                    }
                    if (this.isRelop()) {
                        this.shift(10200);
                        break;
                    }
                    if (this.equalTo((Object)BcLogical.AND)) {
                        this.shift(10210);
                        break;
                    }
                    this.pop();
                    this.pop();
                    this.pop();
                    b.append("\uff5c");
                    this.setGoto(BcNonterminal.EXPR);
                    break;
                }
                case 14000: {
                    if (this.isSymbol()) {
                        this.shift(14010);
                        break;
                    }
                    throw new BcSyntaxException();
                }
                case 14010: {
                    BcSymbol y1 = (BcSymbol)this.pop();
                    this.pop();
                    b.format("\u6570%c", Character.valueOf(ns.getCharacter(y1.toString())));
                    this.setGoto(BcNonterminal.EXPR);
                }
            }
        }
    }

    private static interface V0 {
        public String storeToString();

        public String storeopToString(char var1);
    }

    private static class VA
    implements V0 {
        char ch;

        VA(char c) {
            this.ch = c;
        }

        public String storeToString() {
            return String.format("ds%cr:%cl%c", Character.valueOf('\uff01'), Character.valueOf(this.ch), Character.valueOf('\uff01'));
        }

        public String storeopToString(char op) {
            return String.format("rds%c;%cr%cdl%c:%c", Character.valueOf('\uff02'), Character.valueOf(this.ch), Character.valueOf(op), Character.valueOf('\uff02'), Character.valueOf(this.ch));
        }

        public String toString() {
            return ";" + this.ch;
        }
    }

    private static class VS
    implements V0 {
        char ch;

        VS(char c) {
            this.ch = c;
        }

        public String storeToString() {
            return "ds" + this.ch;
        }

        public String storeopToString(char op) {
            return String.format("l%cr%cds%c", Character.valueOf(this.ch), Character.valueOf(op), Character.valueOf(this.ch));
        }

        public String toString() {
            return "l" + this.ch;
        }
    }
}

