/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.bc;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.morilib.bc.BcNamespace;
import net.morilib.bc.BcSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BcRootNamespace
implements BcNamespace {
    static final char MAX = '\ua000';
    static final char MAX_LOCAL = '\ud800';
    static final char MAX_FUNCTION = '\u2000';
    static final char MAX_LOOP = '\uff00';
    static final char TMP_ARRAY1 = '\uff01';
    static final char TMP_ARRAY2 = '\uff02';
    static final char SCALE = '\uff03';
    static final char IBASE = '\uff04';
    static final char OBASE = '\uff05';
    static final char ROUND = '\uff06';
    private Map<String, Character> allocated = new HashMap<String, Character>();
    private Map<String, Integer> arities = new HashMap<String, Integer>();
    private Map<String, Character> locals = new HashMap<String, Character>();
    private Map<String, Character> functions = new HashMap<String, Character>();
    private int varch = 19968;
    private int functionch = 192;
    private int localch = 44032;
    private int loopch = 65024;

    @Override
    public char getCharacter(String name) {
        if (this.locals.containsKey(name)) {
            return this.locals.get(name).charValue();
        }
        if (name.equals("scale")) {
            return '\uff03';
        }
        if (name.equals("pi") || name.equals("\u03c0")) {
            return '\u03c0';
        }
        if (name.equals("roundingmode")) {
            return '\uff06';
        }
        if (this.allocated.containsKey(name)) {
            return this.allocated.get(name).charValue();
        }
        return this.allocCharacter(name);
    }

    @Override
    public char getFunction(String name) {
        if (this.functions.containsKey(name)) {
            return this.functions.get(name).charValue();
        }
        throw new BcSyntaxException();
    }

    @Override
    public char allocCharacter(String name) {
        if (this.varch < 40960) {
            this.allocated.put(name, Character.valueOf((char)this.varch));
            return (char)this.varch++;
        }
        throw new BcSyntaxException();
    }

    @Override
    public char allocLocalCharacter(String name) {
        if (this.localch < 55296) {
            this.locals.put(name, Character.valueOf((char)this.localch));
            return (char)this.localch++;
        }
        throw new BcSyntaxException();
    }

    @Override
    public void clearLocalCharacter() {
        this.locals.clear();
    }

    @Override
    public char defineFunction(String name, boolean vargs, List<String> args) {
        this.arities.put(name, vargs ? -args.size() - 1 : args.size());
        if (this.functionch < 8192) {
            this.functions.put(name, Character.valueOf((char)this.functionch));
            return (char)this.functionch++;
        }
        throw new BcSyntaxException();
    }

    @Override
    public int getArity(String name) {
        if (!this.arities.containsKey(name)) {
            return -1;
        }
        int x = this.arities.get(name);
        if (x < 0) {
            return -x - 1;
        }
        return x;
    }

    @Override
    public boolean isVarargs(String name) {
        return this.arities.get(name) != null && this.arities.get(name) < 0;
    }

    @Override
    public int getLocalStart() {
        return 40960;
    }

    @Override
    public void popLoop() {
        --this.loopch;
    }

    @Override
    public char pushLoop() {
        return (char)this.loopch++;
    }
}

