/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.dc;

import java.io.IOException;
import java.io.Reader;

public class LookaheadReader
extends Reader {
    private Reader rd;
    private char[] buf;
    private int blen;

    public LookaheadReader(Reader rd, int n) throws IOException {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.rd = rd;
        this.buf = new char[n];
        this.blen = rd.read(this.buf);
    }

    public void close() throws IOException {
        this.rd.close();
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.blen <= 0) {
            return -1;
        }
        if (len < this.blen) {
            int l = this.blen - len;
            System.arraycopy(this.buf, 0, cbuf, off, len);
            System.arraycopy(this.buf, len, this.buf, 0, l);
            this.blen = len + this.rd.read(this.buf, cbuf.length, l);
            return len;
        }
        if (len == this.blen) {
            System.arraycopy(this.buf, 0, cbuf, off, len);
            this.blen = this.rd.read(this.buf, 0, len);
            return len;
        }
        System.arraycopy(this.buf, 0, cbuf, off, this.blen);
        int m = this.blen;
        int l = this.rd.read(this.buf, off + len, len - this.blen);
        if (l < 0) {
            this.blen = 0;
            this.buf = null;
            return m;
        }
        this.blen = this.rd.read(this.buf);
        return m + l;
    }

    public boolean isEof() {
        return this.blen <= 0;
    }

    public char lookahead(int n) {
        if (n < 0 || n >= this.blen) {
            throw new IllegalArgumentException();
        }
        return this.buf[n];
    }
}

