/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.diff;

import java.util.Arrays;
import net.morilib.diff.EditScript;
import net.morilib.diff.InitialScript;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EditMatrix<T> {
    EditScript[] scripts;
    int[] distances;
    private int sizeA;
    private int sizeB;

    EditMatrix(int a, int b) {
        this.sizeA = a + 1;
        this.sizeB = b + 1;
        this.scripts = new EditScript[this.sizeA * this.sizeB];
        this.distances = new int[this.sizeA * this.sizeB];
        Arrays.fill(this.distances, -1);
        this.scripts[0] = new InitialScript();
        this.distances[0] = 0;
    }

    EditScript<T> getScripts(int i, int j) {
        if (i < 0 || i >= this.sizeA) {
            throw new IndexOutOfBoundsException();
        }
        if (j < 0 || j >= this.sizeB) {
            throw new IndexOutOfBoundsException();
        }
        return this.scripts[i * this.sizeB + j];
    }

    void setScripts(int i, int j, EditScript<T> s) {
        if (i < 0 || i >= this.sizeA) {
            throw new IndexOutOfBoundsException();
        }
        if (j < 0 || j >= this.sizeB) {
            throw new IndexOutOfBoundsException();
        }
        this.scripts[i * this.sizeB + j] = s;
    }

    int getDistance(int i, int j) {
        if (i < 0 || i >= this.sizeA) {
            throw new IndexOutOfBoundsException();
        }
        if (j < 0 || j >= this.sizeB) {
            throw new IndexOutOfBoundsException();
        }
        return this.distances[i * this.sizeB + j];
    }

    void setDistance(int i, int j, int d) {
        if (i < 0 || i >= this.sizeA) {
            throw new IndexOutOfBoundsException();
        }
        if (j < 0 || j >= this.sizeB) {
            throw new IndexOutOfBoundsException();
        }
        this.distances[i * this.sizeB + j] = d;
    }

    boolean isKnown(int i, int j) {
        return this.getDistance(i, j) >= 0;
    }

    boolean canApplyRule1(int m, int i, int j) {
        return i >= 0 && i < this.sizeA && j > 0 && j < this.sizeB && this.isKnown(i, j - 1) && this.getDistance(i, j - 1) < m && this.getScripts(i, j - 1) != null && !this.isKnown(i, j);
    }

    boolean canApplyRule2(int m, int i, int j) {
        return i > 0 && i < this.sizeA && j >= 0 && j < this.sizeB && this.isKnown(i - 1, j) && this.getDistance(i - 1, j) < m && this.getScripts(i - 1, j) != null && !this.isKnown(i, j);
    }

    private boolean _equals(Object a, Object b) {
        return a != null ? a.equals(b) : b == null;
    }

    boolean canApplyRule3(int m, int i, int j, T a, T b) {
        return i > 0 && i < this.sizeA && j > 0 && j < this.sizeB && this.isKnown(i - 1, j - 1) && this.getDistance(i - 1, j - 1) < m && this.getScripts(i - 1, j - 1) != null && this._equals(a, b);
    }
}

