/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sh.builtin;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShFileSystem;
import net.morilib.sh.ShProcess;

public class ShBasename
implements ShProcess {
    private static final Pattern PTN = Pattern.compile("([^/]*)/*$");

    public int main(ShEnvironment env, ShFileSystem fs, InputStream in, PrintStream out, PrintStream err, String ... args) throws IOException {
        if (args.length < 2) {
            err.println("basename: illegal argument");
            return 2;
        }
        String s = args[1];
        Matcher m = PTN.matcher(s);
        String string = s = m.find() ? m.group(1) : s;
        if (args.length >= 3 && s.endsWith(args[2])) {
            s = s.substring(0, s.length() - args[2].length());
        }
        out.println(s);
        return 0;
    }
}

