/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sh.builtin;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShFile;
import net.morilib.sh.ShFileSystem;
import net.morilib.sh.ShProcess;
import net.morilib.sh.ShStat;
import net.morilib.unix.misc.OptionIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShD
implements ShProcess {
    private static final SimpleDateFormat FMT = new SimpleDateFormat("yyyy/MM/dd  HH:mm:ss");
    private static final int CLASSIFY = 1;
    private static final int RECURSIVE = 2;
    private static final int ALL = 4;
    private static final int DIRECTORY = 8;
    private static final int HIDE_CONTROL_CHARS = 16;
    private static final int REVERSE = 32;
    private static final int SINGLE_COLUMN = 64;
    private static final Comparator<ShStat> MT = new Comparator<ShStat>(){

        @Override
        public int compare(ShStat a, ShStat b) {
            return a.getMtime() < b.getMtime() ? -1 : (a.getMtime() > b.getMtime() ? 1 : 0);
        }
    };
    private static final Comparator<ShStat> NM = new Comparator<ShStat>(){

        @Override
        public int compare(ShStat a, ShStat b) {
            return a.getFilename().compareTo(b.getFilename());
        }
    };
    private static final Comparator<ShStat> RM = new Comparator<ShStat>(){

        @Override
        public int compare(ShStat a, ShStat b) {
            return a.getMtime() < b.getMtime() ? 1 : (a.getMtime() > b.getMtime() ? -1 : 0);
        }
    };
    private static final Comparator<ShStat> RN = new Comparator<ShStat>(){

        @Override
        public int compare(ShStat a, ShStat b) {
            return -a.getFilename().compareTo(b.getFilename());
        }
    };

    private static void q(SortedMap<String, SortedSet<ShStat>> m, SortedSet<ShStat> r, Comparator<ShStat> c, int g, ShFileSystem fs, ShFile f) {
        if (f == null) {
            for (ShFile x : fs.getCurrentDirectory().getFiles()) {
                if ((g & 4) == 0 && x.isHidden()) continue;
                ShD.q(m, r, c, g, fs, x);
            }
        } else if ((g & 2) != 0 && f.isDirectory()) {
            TreeSet<ShStat> z = new TreeSet<ShStat>(c);
            for (ShFile x : f.getFiles()) {
                ShD.q(m, z, c, g, fs, x);
            }
            m.put(f.toString(), z);
            r.add(f.getStat());
        } else {
            r.add(f.getStat());
        }
    }

    private String _l(int f, String s) {
        return s;
    }

    private void _pr1(int f, PrintStream out, SortedSet<ShStat> s) {
        for (ShStat x : s) {
            out.println(this._l(f, x.getFilename()));
        }
    }

    private void _prs(int f, PrintStream out, SortedSet<ShStat> s) {
        int g;
        char[] a = new char[4];
        int d = 0;
        for (ShStat x : s) {
            g = Long.toString(x.getSize()).length();
            int n = d = d < g ? g : d;
        }
        for (ShStat x : s) {
            g = x.getFlags();
            a[0] = (g & 8) != 0 ? 100 : 45;
            a[1] = (g & 1) != 0 ? 114 : 45;
            a[2] = (g & 2) != 0 ? 119 : 45;
            a[3] = (g & 4) != 0 ? 120 : 45;
            String t = this._l(f, x.getFilename());
            if ((f & 1) != 0) {
                if (a[0] == 'd') {
                    t = String.valueOf(t) + "/";
                } else if (a[3] == 'x') {
                    t = String.valueOf(t) + "*";
                }
            }
            out.format("%s %s %" + d + "d %s\n", new String(a), FMT.format(new Date(x.getMtime())), x.getSize(), t);
        }
    }

    @Override
    public int main(ShEnvironment env, ShFileSystem fs, InputStream in, PrintStream out, PrintStream err, String ... args) throws IOException {
        String[] a = new String[args.length - 1];
        Comparator<ShStat> c = NM;
        int f = 0;
        int r = 0;
        String d = "";
        System.arraycopy(args, 1, a, 0, a.length);
        OptionIterator o = new OptionIterator("FRadqrt1", a);
        while (o.hasNext()) {
            switch (o.nextChar()) {
                case 'F': {
                    f |= 1;
                    break;
                }
                case 'R': {
                    f |= 2;
                    break;
                }
                case 'a': {
                    f |= 4;
                    break;
                }
                case 'd': {
                    f |= 8;
                    break;
                }
                case 'q': {
                    f |= 0x10;
                    break;
                }
                case 'r': {
                    f |= 0x20;
                    break;
                }
                case '1': {
                    f |= 0x40;
                    break;
                }
                case 't': {
                    c = MT;
                    break;
                }
                default: {
                    err.print("d: unrecognized option: ");
                    err.println((char)o.getErrorOption());
                    return 2;
                }
            }
        }
        if ((f & 0x20) != 0) {
            c = c == MT ? RM : RN;
        }
        Iterator<String> t = o.filenameIterator();
        TreeSet<ShStat> s = new TreeSet<ShStat>(c);
        TreeMap<String, SortedSet<ShStat>> m = new TreeMap<String, SortedSet<ShStat>>();
        if (t.hasNext()) {
            while (t.hasNext()) {
                String v = t.next();
                ShFile z = fs.getFile(v);
                if (!z.isExist()) {
                    err.print("d: file `");
                    err.print(v);
                    err.println("' not found.");
                    r = 2;
                    continue;
                }
                if ((f & 8) == 0 && z.isDirectory()) {
                    TreeSet<ShStat> w = new TreeSet<ShStat>(c);
                    for (ShFile x : z.getFiles()) {
                        ShD.q(m, w, c, f, fs, x);
                    }
                    m.put(z.toString(), w);
                    continue;
                }
                ShD.q(m, s, c, f, fs, z);
            }
        } else {
            ShD.q(m, s, c, f, fs, null);
        }
        if ((f & 0x40) != 0) {
            this._pr1(f, out, s);
            if (!s.isEmpty()) {
                out.println();
            }
            for (String b : m.keySet()) {
                out.print(d);
                d = "\n";
                out.print(b);
                out.println(':');
                this._pr1(f, out, (SortedSet)m.get(b));
            }
        } else {
            this._prs(f, out, s);
            if (!s.isEmpty()) {
                out.println();
            }
            for (String b : m.keySet()) {
                out.print(d);
                d = "\n";
                out.print(b);
                out.println(':');
                this._prs(f, out, (SortedSet)m.get(b));
            }
        }
        return r;
    }
}

