/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sh.builtin;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Iterator;
import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShFileSystem;
import net.morilib.sh.ShProcess;
import net.morilib.unix.misc.OptionIterator;

public class ShRm
implements ShProcess {
    private static final int FORCE = 1;
    private static final int INTERACTIVE = 2;
    private static final int VERBOSE = 4;

    public int main(ShEnvironment env, ShFileSystem fs, InputStream in, PrintStream out, PrintStream err, String ... args) throws IOException {
        String[] a = new String[args.length - 1];
        int f = 0;
        int r = 0;
        System.arraycopy(args, 1, a, 0, a.length);
        OptionIterator o = new OptionIterator("firv", a);
        while (o.hasNext()) {
            if (o.getLookahead().equals("--interactive")) {
                f |= 2;
                o.nextChar();
                continue;
            }
            if (o.getLookahead().equals("--force")) {
                f |= 1;
                o.nextChar();
                continue;
            }
            if (o.getLookahead().equals("--recursive")) {
                err.print("rm: removing recursively");
                err.println(" is not supported.");
                return 2;
            }
            if (o.getLookahead().equals("--verbose")) {
                f |= 4;
                o.nextChar();
                continue;
            }
            switch (o.nextChar()) {
                case 'f': {
                    f |= 1;
                    break;
                }
                case 'i': {
                    f |= 2;
                    break;
                }
                case 'v': {
                    f |= 4;
                    break;
                }
                case 'r': {
                    err.print("rm: removing recursively");
                    err.println(" is not supported.");
                    return 2;
                }
                default: {
                    err.print("rm: unrecognized option: ");
                    err.println((char)o.getErrorOption());
                    return 2;
                }
            }
        }
        Iterator<String> t = o.filenameIterator();
        BufferedReader rd = new BufferedReader(new InputStreamReader(in, env.getCharset()));
        while (t.hasNext()) {
            String s = t.next();
            if ((f & 2) != 0) {
                err.print("rm: remove file `");
                err.print(s);
                err.print("'? ");
                String x = rd.readLine();
                if (!x.equalsIgnoreCase("y") && !x.equalsIgnoreCase("yes")) continue;
            }
            if ((f & 4) != 0) {
                out.println(s);
            }
            if (fs.getFile(s).deleteFile()) continue;
            err.print("rm: cannot remove `");
            err.print(s);
            err.println("'.");
            r = 2;
        }
        return r;
    }
}

