/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sh.testcmd;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShFileSystem;
import net.morilib.sh.ShProcess;
import net.morilib.sh.misc.LookaheadIterator;
import net.morilib.sh.misc.WrappedLookaheadIterator;
import net.morilib.sh.testcmd.ShTest1Term;
import net.morilib.sh.testcmd.ShTest2Terms;
import net.morilib.sh.testcmd.ShTestStrategies;
import net.morilib.sh.testcmd.ShTestSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ShTestParser
implements ShProcess {
    private Map<String, ShTest1Term> sgl;
    private Map<String, ShTest2Terms> dbl;

    public static ShTestParser getDefault() {
        HashMap<String, ShTest1Term> ma = new HashMap<String, ShTest1Term>();
        ma.put("-a", ShTestStrategies.EXIST);
        ma.put("-d", ShTestStrategies.DIRECTORY);
        ma.put("-e", ShTestStrategies.EXIST);
        ma.put("-f", ShTestStrategies.FILE);
        ma.put("-r", ShTestStrategies.READABLE);
        ma.put("-s", ShTestStrategies.NOTZEROFILE);
        ma.put("-w", ShTestStrategies.WRITABLE);
        ma.put("-x", ShTestStrategies.EXECUTABLE);
        ma.put("-z", ShTestStrategies.EMPTY);
        ma.put("-n", ShTestStrategies.NONEMPTY);
        HashMap<String, ShTest2Terms> mb = new HashMap<String, ShTest2Terms>();
        mb.put("-nt", ShTestStrategies.NEWER);
        mb.put("-ot", ShTestStrategies.OLDER);
        mb.put("=", ShTestStrategies.EQUALS);
        mb.put("!=", ShTestStrategies.NOT_EQUALS);
        mb.put("<", ShTestStrategies.LESS);
        mb.put("<=", ShTestStrategies.LESS_EQ);
        mb.put(">", ShTestStrategies.GREATER);
        mb.put(">=", ShTestStrategies.GREATER_EQ);
        mb.put("-eq", ShTestStrategies.EQ);
        mb.put("-ne", ShTestStrategies.NE);
        mb.put("-lt", ShTestStrategies.LT);
        mb.put("-le", ShTestStrategies.LE);
        mb.put("-gt", ShTestStrategies.GT);
        mb.put("-ge", ShTestStrategies.GE);
        return new ShTestParser(ma, mb);
    }

    ShTestParser(Map<String, ShTest1Term> sgl, Map<String, ShTest2Terms> dbl) {
        this.sgl = sgl;
        this.dbl = dbl;
    }

    private boolean ismeta(Object s) {
        return s.equals("(") || s.equals(")") || s.equals("!") || s.equals("-a") || s.equals("-o");
    }

    private void shift(List<Object> s, List<S1> t, LookaheadIterator<String> r, S1 stat) {
        if (r.hasNext()) {
            s.add(0, r.next());
        }
    }

    private Object look(LookaheadIterator<String> r) {
        return r.hasNext() ? (Serializable)((Object)r.peek()) : Integer.valueOf(Integer.MAX_VALUE);
    }

    int parseLR(ShFileSystem fs, LookaheadIterator<String> r) {
        LinkedList<Object> s = new LinkedList<Object>();
        LinkedList<S1> t = new LinkedList<S1>();
        S1 stat = S1.S00;
        s.add(0, Integer.MAX_VALUE);
        t.add(0, stat);
        while (true) {
            switch (stat) {
                case S00: {
                    if (s.get(0) instanceof Boolean) {
                        stat = S1.S01;
                        break;
                    }
                    if (this.look(r).equals("(")) {
                        this.shift(s, t, r, stat);
                        stat = S1.S06;
                        break;
                    }
                    if (this.sgl.containsKey(this.look(r))) {
                        this.shift(s, t, r, stat);
                        stat = S1.S09;
                        break;
                    }
                    if (this.look(r).equals("!")) {
                        this.shift(s, t, r, stat);
                        stat = S1.S14;
                        break;
                    }
                    this.shift(s, t, r, stat);
                    stat = S1.S11;
                    break;
                }
                case S01: {
                    if (!r.hasNext()) {
                        return (Boolean)s.get(0) != false ? 0 : 1;
                    }
                    if (this.look(r).equals("-o")) {
                        this.shift(s, t, r, stat);
                        stat = S1.S02;
                        break;
                    }
                    if (this.look(r).equals("-a")) {
                        this.shift(s, t, r, stat);
                        stat = S1.S04;
                        break;
                    }
                    throw new ShTestSyntaxException();
                }
                case S02: {
                    if (s.get(0) instanceof Boolean) {
                        stat = S1.S03;
                        break;
                    }
                    if (this.look(r).equals("(")) {
                        this.shift(s, t, r, stat);
                        stat = S1.S06;
                        break;
                    }
                    if (this.sgl.containsKey(this.look(r))) {
                        this.shift(s, t, r, stat);
                        stat = S1.S09;
                        break;
                    }
                    if (this.look(r).equals("!")) {
                        this.shift(s, t, r, stat);
                        stat = S1.S14;
                        break;
                    }
                    this.shift(s, t, r, stat);
                    stat = S1.S11;
                    break;
                }
                case S03: {
                    if (this.look(r).equals("-a")) {
                        this.shift(s, t, r, stat);
                        stat = S1.S04;
                        break;
                    }
                    boolean b = (Boolean)s.remove(0);
                    s.remove(0);
                    boolean a = (Boolean)s.remove(0);
                    t.remove(0);
                    t.remove(0);
                    t.remove(0);
                    s.add(0, a | b);
                    stat = (S1)((Object)t.remove(0));
                    break;
                }
                case S04: {
                    if (s.get(0) instanceof Boolean) {
                        stat = S1.S05;
                        break;
                    }
                    if (this.look(r).equals("(")) {
                        this.shift(s, t, r, stat);
                        stat = S1.S06;
                        break;
                    }
                    if (this.sgl.containsKey(this.look(r))) {
                        this.shift(s, t, r, stat);
                        stat = S1.S09;
                        break;
                    }
                    if (this.look(r).equals("!")) {
                        this.shift(s, t, r, stat);
                        stat = S1.S14;
                        break;
                    }
                    this.shift(s, t, r, stat);
                    stat = S1.S11;
                    break;
                }
                case S05: {
                    boolean b = (Boolean)s.remove(0);
                    s.remove(0);
                    boolean a = (Boolean)s.remove(0);
                    t.remove(0);
                    t.remove(0);
                    t.remove(0);
                    s.add(0, a & b);
                    stat = (S1)((Object)t.remove(0));
                    break;
                }
                case S06: {
                    if (s.get(0) instanceof Boolean) {
                        stat = S1.S07;
                        break;
                    }
                    if (this.look(r).equals("(")) {
                        this.shift(s, t, r, stat);
                        stat = S1.S06;
                        break;
                    }
                    if (this.sgl.containsKey(this.look(r))) {
                        this.shift(s, t, r, stat);
                        stat = S1.S09;
                        break;
                    }
                    if (this.look(r).equals("!")) {
                        this.shift(s, t, r, stat);
                        stat = S1.S14;
                        break;
                    }
                    this.shift(s, t, r, stat);
                    stat = S1.S11;
                    break;
                }
                case S07: {
                    if (this.look(r).equals("-o")) {
                        this.shift(s, t, r, stat);
                        stat = S1.S02;
                        break;
                    }
                    if (this.look(r).equals("-a")) {
                        this.shift(s, t, r, stat);
                        stat = S1.S04;
                        break;
                    }
                    if (this.look(r).equals(")")) {
                        this.shift(s, t, r, stat);
                        stat = S1.S08;
                        break;
                    }
                    throw new ShTestSyntaxException();
                }
                case S08: {
                    s.remove(0);
                    Object o = s.remove(0);
                    s.remove(0);
                    t.remove(0);
                    t.remove(0);
                    t.remove(0);
                    s.add(0, o);
                    stat = (S1)((Object)t.remove(0));
                    break;
                }
                case S09: {
                    if (!this.ismeta(this.look(r))) {
                        this.shift(s, t, r, stat);
                        stat = S1.S10;
                        break;
                    }
                    throw new ShTestSyntaxException();
                }
                case S10: {
                    String x = s.remove(0).toString();
                    Object o = s.remove(0);
                    t.remove(0);
                    t.remove(0);
                    s.add(0, this.sgl.get(o).eval(fs, x) == 0);
                    stat = (S1)((Object)t.remove(0));
                    break;
                }
                case S11: {
                    if (this.dbl.containsKey(this.look(r))) {
                        this.shift(s, t, r, stat);
                        stat = S1.S12;
                        break;
                    }
                    String x = s.remove(0).toString();
                    t.remove(0);
                    s.add(0, x.length() > 0);
                    stat = (S1)((Object)t.remove(0));
                    break;
                }
                case S12: {
                    if (!this.ismeta(this.look(r))) {
                        this.shift(s, t, r, stat);
                        stat = S1.S13;
                        break;
                    }
                    throw new ShTestSyntaxException();
                }
                case S13: {
                    String y = s.remove(0).toString();
                    Object o = s.remove(0);
                    String x = s.remove(0).toString();
                    t.remove(0);
                    t.remove(0);
                    t.remove(0);
                    s.add(0, this.dbl.get(o).eval(fs, x, y) == 0);
                    stat = (S1)((Object)t.remove(0));
                    break;
                }
                case S14: {
                    if (s.get(0) instanceof Boolean) {
                        stat = S1.S15;
                        break;
                    }
                    if (this.look(r).equals("(")) {
                        this.shift(s, t, r, stat);
                        stat = S1.S06;
                        break;
                    }
                    if (this.sgl.containsKey(this.look(r))) {
                        this.shift(s, t, r, stat);
                        stat = S1.S09;
                        break;
                    }
                    if (this.look(r).equals("!")) {
                        this.shift(s, t, r, stat);
                        stat = S1.S14;
                        break;
                    }
                    this.shift(s, t, r, stat);
                    stat = S1.S11;
                    break;
                }
                case S15: {
                    boolean a = (Boolean)s.remove(0);
                    s.remove(0);
                    t.remove(0);
                    t.remove(0);
                    s.add(0, !a);
                    stat = (S1)((Object)t.remove(0));
                }
            }
            t.add(0, stat);
        }
    }

    public int parse(ShFileSystem fs, String ... args) {
        WrappedLookaheadIterator<String> r = new WrappedLookaheadIterator<String>(Arrays.asList(args).iterator());
        if (r.hasNext()) {
            r.next();
        }
        return this.parseLR(fs, r);
    }

    @Override
    public int main(ShEnvironment env, ShFileSystem fs, InputStream stdin, PrintStream stdout, PrintStream stderr, String ... args) throws IOException {
        return this.parse(fs, args);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum S1 {
        S00,
        S01,
        S02,
        S03,
        S04,
        S05,
        S06,
        S07,
        S08,
        S09,
        S10,
        S11,
        S12,
        S13,
        S14,
        S15;

    }
}

