/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.encoding;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import net.morilib.awk.encoding.AbstractEncodingDetectorResource;

public class EncodingDetectorResource_ja
extends AbstractEncodingDetectorResource {
    private static final int SIZE = 1024;
    private static final Charset JIS = Charset.forName("ISO-2022-JP");
    private static final String[] CODES = new String[]{"UTF-8", "Windows-31J", "EUC-JP", "UTF-16BE", "UTF-16LE"};

    static boolean detectJIS(byte[] a) {
        int stat = 1000;
        int i = 0;
        while (i < a.length) {
            if (a[i] < 0) {
                return false;
            }
            switch (stat) {
                case 1000: {
                    stat = a[i] == 27 ? 1010 : 1000;
                    break;
                }
                case 1010: {
                    stat = a[i] == 36 ? 1020 : (a[i] == 27 ? 1010 : 1000);
                    break;
                }
                case 1020: {
                    if (a[i] == 66) {
                        return true;
                    }
                    stat = a[i] == 27 ? 1010 : 1000;
                }
            }
            ++i;
        }
        return false;
    }

    public Charset detect(InputStream ins) throws IOException {
        byte[] a = new byte[1024];
        CharBuffer cb = CharBuffer.allocate(1024);
        int l = ins.read(a);
        if (EncodingDetectorResource_ja.detectJIS(a)) {
            return JIS;
        }
        String[] stringArray = CODES;
        int n = CODES.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            Charset ch = Charset.forName(s);
            CharsetDecoder cd = ch.newDecoder();
            cd.onMalformedInput(CodingErrorAction.REPORT);
            ByteBuffer bb = ByteBuffer.wrap(a, 0, l);
            CoderResult cr = cd.decode(bb, cb, false);
            if (!cr.isError()) {
                return ch;
            }
            ++n2;
        }
        return Charset.defaultCharset();
    }
}

