/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.expr;

import java.util.ArrayList;
import java.util.Collection;
import net.morilib.awk.AwkCastException;
import net.morilib.awk.AwkLocation;
import net.morilib.awk.AwkUnboundException;
import net.morilib.awk.expr.AwkExpression;
import net.morilib.awk.expr.AwkReferVariable;
import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkClass;
import net.morilib.awk.value.AwkFunction;
import net.morilib.awk.value.AwkValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AwkApplier
extends AwkExpression {
    private AwkExpression function;
    private AwkExpression[] args;

    public AwkApplier(AwkExpression function, Collection<AwkExpression> args) {
        this.function = function;
        this.args = args.toArray(new AwkExpression[0]);
    }

    private AwkNamespace searchns(AwkNamespace t, AwkLocation m) {
        int i = 0;
        while (i < m.sizeOfPath() - 1) {
            AwkNamespace v = t.referNamespace(m.getPathOf(i));
            AwkValue w = t.find(m.getPathOf(i));
            if (w != null && w.getNamespace() != null) {
                t = w.getNamespace();
            } else if (v != null) {
                t = v;
            } else {
                return null;
            }
            ++i;
        }
        return t;
    }

    @Override
    public AwkValue eval(AwkNamespace s, AwkFiles o) {
        ArrayList<AwkValue> l = new ArrayList<AwkValue>();
        AwkNamespace t = null;
        AwkValue f = null;
        AwkExpression[] awkExpressionArray = this.args;
        int n = this.args.length;
        int n2 = 0;
        while (n2 < n) {
            AwkExpression e = awkExpressionArray[n2];
            l.add(e.eval(s, o));
            ++n2;
        }
        if (this.function instanceof AwkReferVariable) {
            AwkLocation m = ((AwkReferVariable)this.function).getLocation();
            if (!m.isRoot() && (t = this.searchns(s, m)) != null && (f = t.findFunction(m.getName())) == null) {
                f = t.find(m.getName());
            }
            if (f == null) {
                t = s;
                while (!t.isRoot()) {
                    t = t.getRoot();
                }
                if ((t = this.searchns(t, m)) != null) {
                    f = t.findFunction(m.getName());
                }
            }
            if (f == null) {
                throw new AwkUnboundException("unbound function " + m.toString());
            }
            if (!(f instanceof AwkFunction)) {
                throw new AwkCastException("function required");
            }
            AwkFunction g = f;
            if (g.getName().equals("new") && !t.isRoot()) {
                t = t.newInstance();
                g.init(t, o, l);
                return new AwkClass(t);
            }
            return g.apply(t, o, l);
        }
        AwkValue fn = this.function.eval(s, o);
        if (fn instanceof AwkFunction) {
            AwkFunction g = (AwkFunction)fn;
            return g.apply(g.getEnvironment(), o, l);
        }
        throw new AwkCastException("function required");
    }
}

