/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.misc;

import java.io.IOException;
import java.io.Reader;
import net.morilib.awk.misc.PushbackLineNumberReadable;

public class PromptReader
implements PushbackLineNumberReadable {
    private int unread = -1;
    private int lineno = 1;
    private Reader rd;
    private String prompt1;
    private String prompt2;
    private String prompt;
    private boolean isno = false;

    public PromptReader(String prompt1, String prompt2, Reader rd) {
        this.prompt1 = prompt1;
        this.prompt2 = this.prompt = prompt2;
        this.rd = rd;
        System.out.print(prompt1);
    }

    public void unread(int c) throws IOException {
        this.unread = c;
    }

    public int getLineNumber() {
        return this.lineno;
    }

    public void close() throws IOException {
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        int i = off;
        while (i < off + len) {
            int c = this.read();
            if (c < 0) {
                return i - off;
            }
            cbuf[i] = (char)c;
            ++i;
        }
        return len;
    }

    public int read(char[] cbuf) throws IOException {
        return this.read(cbuf, 0, cbuf.length);
    }

    public int read() throws IOException {
        if (this.isno) {
            System.out.print(this.prompt);
        }
        this.isno = false;
        if (this.unread >= 0) {
            int c = this.unread;
            this.unread = -1;
            return c;
        }
        int c = this.rd.read();
        if (c < 0) {
            return -1;
        }
        if (c == 13) {
            return this.read();
        }
        if (c == 10) {
            this.prompt = this.prompt2;
            this.isno = true;
            return c;
        }
        return c;
    }

    public void resetPrompt() throws IOException {
        this.prompt = this.prompt1;
        while (this.rd.ready()) {
            this.rd.read();
        }
        this.unread = -1;
        this.isno = true;
    }

    public boolean isNewline() throws IOException {
        if (this.unread == 10) {
            return true;
        }
        if (this.unread < 0) {
            int c;
            while ((c = this.rd.read()) == 32 || c == 9 || c == 13) {
            }
            this.unread = c;
            this.isno = c == 10;
            return this.isno;
        }
        return false;
    }
}

