/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.misc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.morilib.awk.misc.Objects;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Strings {
    private static final int PADDING_CHAR = 32;
    private static final String BLANK_CHARS = " \t";
    public static final boolean UNTIL = true;
    public static final boolean WHILE = false;

    private Strings() {
    }

    static StringBuffer appendFill(StringBuffer buf, int c, int len) {
        int i = 0;
        while (i < len) {
            buf.append((char)c);
            ++i;
        }
        return buf;
    }

    static StringBuffer buildFill(int c, int len) {
        return Strings.appendFill(new StringBuffer(), c, len);
    }

    static StringBuffer buildFill(String s, int c, int len) {
        return Strings.appendFill(new StringBuffer(s), c, len);
    }

    public static int find(String line, String str, int begin, int end, boolean type) {
        if (begin < 0 || end < 0 || begin > end) {
            throw new IllegalArgumentException("illegal index: from " + begin + " to " + end);
        }
        if (line == null) {
            return -1;
        }
        end = Math.min(end, line.length());
        int i = begin;
        while (i < end) {
            if (str.indexOf(line.charAt(i)) < 0 ^ type) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int find(String line, String str, int begin, boolean type) {
        return Strings.find(line, str, begin, line.length(), type);
    }

    public static int find(String line, String string, boolean type) {
        return Strings.find(line, string, 0, line.length(), type);
    }

    public static int charAt(String line, int i) {
        return line == null || i < 0 || i >= line.length() ? -1 : (int)line.charAt(i);
    }

    public static boolean isBlank(String x) {
        if (x == null) {
            return false;
        }
        return Strings.find(x, BLANK_CHARS, 1, x.length(), false) < 0;
    }

    public static boolean isEmpty(String x) {
        return x == null || x.equals("");
    }

    public static boolean equals(String x1, String x2) {
        return Objects.equals(x1, x2);
    }

    public static String ltrim(String line) {
        if (line == null) {
            return null;
        }
        int x = Strings.find(line, BLANK_CHARS, false);
        return x < 0 ? "" : Strings.right(line, line.length() - x);
    }

    private static StringBuffer lpad(StringBuffer buf, String s, int len, int c) {
        if (len < 0) {
            throw new IllegalArgumentException("negative length: " + len);
        }
        int l = len - s.length();
        if (l > 0) {
            Strings.appendFill(buf, c, l);
        }
        return buf.append(s);
    }

    private static StringBuffer rpad(StringBuffer buf, String s, int len, int c) {
        if (len < 0) {
            throw new IllegalArgumentException("negative length: " + len);
        }
        int l = len - s.length();
        buf.append(s);
        if (l > 0) {
            Strings.appendFill(buf, c, l);
        }
        return buf;
    }

    public static String lpad(String s, int len, int c) {
        if (s == null) {
            return null;
        }
        return Strings.lpad(new StringBuffer(), s, c, len).toString();
    }

    public static String rpad(String s, int len, int c) {
        if (s == null) {
            return null;
        }
        return Strings.rpad(new StringBuffer(), s, c, len).toString();
    }

    public static String lpad(String s, int len) {
        return Strings.lpad(s, 32, len);
    }

    public static String rpad(String s, int len) {
        return Strings.rpad(s, 32, len);
    }

    public static String nvl(String src) {
        return src != null ? src : "";
    }

    public static String nvl(String src, String ifnull) {
        return src != null ? src : ifnull;
    }

    public static String left(String line, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("the given length is negative:" + length);
        }
        if (line == null) {
            return null;
        }
        if (length == 0) {
            return "";
        }
        return line.length() > length ? line.substring(0, length) : line;
    }

    public static String right(String line, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("the given length is negative:" + length);
        }
        if (line == null) {
            return null;
        }
        if (length == 0) {
            return "";
        }
        int l = line.length();
        return l > length ? line.substring(l - length, l) : line;
    }

    public static String chop(String line) {
        if (line == null) {
            return null;
        }
        int x = line.length();
        return x > 0 ? line.substring(0, x - 1) : "";
    }

    public static String chomp(String line, int separator) {
        if (line == null) {
            return null;
        }
        int x = line.length();
        return x > 0 && line.charAt(x - 1) == separator ? line.substring(0, x - 1) : line;
    }

    public static String chomp(String line) {
        return Strings.chomp(line, 10);
    }

    public static String putKeyValue(Object key, Object value, String delimiter) {
        if (key == null || delimiter == null) {
            throw new IllegalArgumentException("the argument(s) is null");
        }
        return key + delimiter + Objects.toString(value);
    }

    public static String putKeyValue(Object key, Object value) {
        return Strings.putKeyValue(key, value, "=");
    }

    public static String newString(int c) {
        char[] r = new char[]{(char)c};
        return new String(r);
    }

    private static void checkRange(CharSequence s1, CharSequence s2, int b1, int e1, int b2, int e2) {
        if (s1 == null || s2 == null) {
            throw new NullPointerException();
        }
        if (b1 < 0 || b1 >= s1.length()) {
            throw new StringIndexOutOfBoundsException(b1);
        }
        if (e1 < 0 || e1 > s1.length()) {
            throw new StringIndexOutOfBoundsException(e1);
        }
        if (b2 < 0 || b2 >= s2.length()) {
            throw new StringIndexOutOfBoundsException(b2);
        }
        if (e2 < 0 || e2 > s2.length()) {
            throw new StringIndexOutOfBoundsException(e2);
        }
        if (e1 < b1) {
            throw new IllegalArgumentException();
        }
        if (e2 < b2) {
            throw new IllegalArgumentException();
        }
    }

    private static void checkRange(CharSequence s, int b, int e) {
        if (s == null) {
            throw new NullPointerException();
        }
        if (b < 0 || b >= s.length()) {
            throw new StringIndexOutOfBoundsException(b);
        }
        if (e < 0 || e > s.length()) {
            throw new StringIndexOutOfBoundsException(e);
        }
        if (e < b) {
            throw new IllegalArgumentException();
        }
    }

    private static void checkRange(char[] s, int b, int e) {
        if (s == null) {
            throw new NullPointerException();
        }
        if (b < 0 || b >= s.length) {
            throw new ArrayIndexOutOfBoundsException(b);
        }
        if (e < 0 || e > s.length) {
            throw new ArrayIndexOutOfBoundsException(e);
        }
        if (e < b) {
            throw new IllegalArgumentException();
        }
    }

    public static boolean equals(CharSequence s1, CharSequence s2, int b1, int e1, int b2, int e2) {
        Strings.checkRange(s1, s2, b1, e1, b2, e2);
        if (e1 - b1 != e2 - b2) {
            return false;
        }
        int i = b1;
        int j = b2;
        while (i < e1) {
            if (s1.charAt(i++) == s2.charAt(j++)) continue;
            return false;
        }
        return true;
    }

    public static int compareTo(CharSequence s1, CharSequence s2, int b1, int e1, int b2, int e2) {
        int i = b1;
        int j = b2;
        Strings.checkRange(s1, s2, b1, e1, b2, e2);
        while (i < e1 && j < e2) {
            char c2;
            char c1;
            if ((c1 = s1.charAt(i++)) < (c2 = s2.charAt(j++))) {
                return -1;
            }
            if (c1 <= c2) continue;
            return 1;
        }
        return j < e2 ? -1 : (i < e1 ? 1 : 0);
    }

    public static boolean equalsIgnoreCase(CharSequence s1, CharSequence s2, int b1, int e1, int b2, int e2) {
        Strings.checkRange(s1, s2, b1, e1, b2, e2);
        if (e1 - b1 != e2 - b2) {
            return false;
        }
        int i = b1;
        int j = b2;
        while (i < e1) {
            char c1 = s1.charAt(i++);
            char c2 = s2.charAt(j++);
            if ((c1 = Character.toLowerCase(Character.toUpperCase(c1))) == (c2 = Character.toLowerCase(Character.toUpperCase(c2)))) continue;
            return false;
        }
        return true;
    }

    public static int compareToIgnoreCase(CharSequence s1, CharSequence s2, int b1, int e1, int b2, int e2) {
        int i = b1;
        int j = b2;
        Strings.checkRange(s1, s2, b1, e1, b2, e2);
        while (i < e1 && j < e2) {
            char c1 = s1.charAt(i++);
            char c2 = s2.charAt(j++);
            if ((c1 = Character.toLowerCase(Character.toUpperCase(c1))) < (c2 = Character.toLowerCase(Character.toUpperCase(c2)))) {
                return -1;
            }
            if (c1 <= c2) continue;
            return 1;
        }
        return j < e2 ? -1 : (i < e1 ? 1 : 0);
    }

    public static int hashCodeIgnoreCase(String s) {
        if (s == null) {
            throw new NullPointerException();
        }
        return s.toUpperCase().toLowerCase().hashCode();
    }

    public static int prefixLength(CharSequence s1, CharSequence s2, int b1, int e1, int b2, int e2) {
        int i = b1;
        int j = b2;
        Strings.checkRange(s1, s2, b1, e1, b2, e2);
        while (i < e1 && j < e2) {
            char c2;
            char c1 = s1.charAt(i);
            if (c1 != (c2 = s2.charAt(j))) {
                return i - b1;
            }
            ++i;
            ++j;
        }
        return i - b1;
    }

    public static int prefixLengthIgnoreCase(CharSequence s1, CharSequence s2, int b1, int e1, int b2, int e2) {
        int i = b1;
        int j = b2;
        Strings.checkRange(s1, s2, b1, e1, b2, e2);
        while (i < e1 && j < e2) {
            char c1 = s1.charAt(i);
            char c2 = s2.charAt(j);
            if ((c1 = Character.toLowerCase(Character.toUpperCase(c1))) != (c2 = Character.toLowerCase(Character.toUpperCase(c2)))) {
                return i - b1;
            }
            ++i;
            ++j;
        }
        return i - b1;
    }

    public static int suffixLength(CharSequence s1, CharSequence s2, int b1, int e1, int b2, int e2) {
        int i = e1 - 1;
        int j = e2 - 1;
        Strings.checkRange(s1, s2, b1, e1, b2, e2);
        while (i >= b1 && j >= b2) {
            char c2;
            char c1 = s1.charAt(i);
            if (c1 != (c2 = s2.charAt(j))) {
                return e1 - 1 - i;
            }
            --i;
            --j;
        }
        return e1 - 1 - i;
    }

    public static int suffixLengthIgnoreCase(CharSequence s1, CharSequence s2, int b1, int e1, int b2, int e2) {
        int i = e1 - 1;
        int j = e2 - 1;
        Strings.checkRange(s1, s2, b1, e1, b2, e2);
        while (i >= b1 && j >= b2) {
            char c1 = s1.charAt(i);
            char c2 = s2.charAt(j);
            if ((c1 = Character.toLowerCase(Character.toUpperCase(c1))) != (c2 = Character.toLowerCase(Character.toUpperCase(c2)))) {
                return e1 - 1 - i;
            }
            --i;
            --j;
        }
        return e1 - 1 - i;
    }

    public static boolean startsWith(CharSequence s2, CharSequence s1, int b2, int e2, int b1, int e1) {
        int i = b2;
        int j = b1;
        Strings.checkRange(s2, s1, b2, e2, b1, e1);
        while (i < e2 && j < e1) {
            char c1;
            char c2 = s2.charAt(i);
            if (c2 != (c1 = s1.charAt(j))) {
                return false;
            }
            ++i;
            ++j;
        }
        return j >= e1;
    }

    public static boolean startsWithIgnoreCase(CharSequence s2, CharSequence s1, int b2, int e2, int b1, int e1) {
        int i = b2;
        int j = b1;
        Strings.checkRange(s2, s1, b2, e2, b1, e1);
        while (i < e2 && j < e1) {
            char c2 = s2.charAt(i);
            char c1 = s1.charAt(j);
            if ((c2 = Character.toLowerCase(Character.toUpperCase(c2))) != (c1 = Character.toLowerCase(Character.toUpperCase(c1)))) {
                return false;
            }
            ++i;
            ++j;
        }
        return j >= e1;
    }

    public static boolean endsWith(CharSequence s2, CharSequence s1, int b2, int e2, int b1, int e1) {
        int i = e2 - 1;
        int j = e1 - 1;
        Strings.checkRange(s2, s1, b2, e2, b1, e1);
        while (i >= b2 && j >= b1) {
            char c1;
            char c2 = s2.charAt(i);
            if (c2 != (c1 = s1.charAt(j))) {
                return false;
            }
            --i;
            --j;
        }
        return j < b1;
    }

    public static boolean endsWithIgnoreCase(CharSequence s2, CharSequence s1, int b2, int e2, int b1, int e1) {
        int i = e2 - 1;
        int j = e1 - 1;
        Strings.checkRange(s2, s1, b2, e2, b1, e1);
        while (i >= b2 && j >= b1) {
            char c2 = s2.charAt(i);
            char c1 = s1.charAt(j);
            if ((c2 = Character.toLowerCase(Character.toUpperCase(c2))) != (c1 = Character.toLowerCase(Character.toUpperCase(c1)))) {
                return false;
            }
            --i;
            --j;
        }
        return j < b1;
    }

    private static char charAtCi(CharSequence s, int at) {
        return Character.toLowerCase(Character.toUpperCase(s.charAt(at)));
    }

    /*
     * Unable to fully structure code
     */
    public static int contains(CharSequence s1, CharSequence s2, int b1, int e1, int b2, int e2) {
        i = b1;
        j = b2;
        Strings.checkRange(s1, s2, b1, e1, b2, e2);
        if (e2 - b2 != 0) ** GOTO lbl8
        return b1;
lbl-1000:
        // 1 sources

        {
            if (++i < e1) continue;
            return -1;
lbl8:
            // 2 sources

            ** while (s1.charAt((int)i) != s2.charAt((int)j))
        }
lbl9:
        // 1 sources

        r = i;
        while (i < e1 && j < e2) {
            c1 = s1.charAt(i);
            if (c1 != (c2 = s2.charAt(j))) {
                return -1;
            }
            ++i;
            ++j;
        }
        return j >= e2 ? r : -1;
    }

    /*
     * Unable to fully structure code
     */
    public static int containsIgnoreCase(CharSequence s1, CharSequence s2, int b1, int e1, int b2, int e2) {
        i = b1;
        j = b2;
        Strings.checkRange(s1, s2, b1, e1, b2, e2);
        if (e2 - b2 != 0) ** GOTO lbl8
        return b1;
lbl-1000:
        // 1 sources

        {
            if (++i < e1) continue;
            return -1;
lbl8:
            // 2 sources

            ** while (Strings.charAtCi((CharSequence)s1, (int)i) != Strings.charAtCi((CharSequence)s2, (int)j))
        }
lbl9:
        // 1 sources

        r = i;
        while (i < e1 && j < e2) {
            c1 = Strings.charAtCi(s1, i);
            if (c1 != (c2 = Strings.charAtCi(s2, j))) {
                return -1;
            }
            ++i;
            ++j;
        }
        return j >= e2 ? r : -1;
    }

    public static char[] toTitleCase(char[] cs, int b, int e) {
        int stat = 0;
        Strings.checkRange(cs, b, e);
        int i = b;
        while (i < e) {
            switch (stat) {
                case 0: {
                    cs[i] = Character.toUpperCase(cs[i]);
                    stat = 1;
                    break;
                }
                case 1: {
                    if (Character.isUpperCase(cs[i]) || cs[i] == '\'' || cs[i] == '\u2019') {
                        cs[i] = Character.toLowerCase(cs[i]);
                        break;
                    }
                    if (Character.isLetter(cs[i])) break;
                    stat = 0;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            ++i;
        }
        return cs;
    }

    public static String toTitleCase(CharSequence cs, int b, int e) {
        StringBuilder bf = new StringBuilder();
        int stat = 0;
        Strings.checkRange(cs, b, e);
        int i = b;
        while (i < e) {
            char ch = cs.charAt(i);
            switch (stat) {
                case 0: {
                    ch = Character.toUpperCase(ch);
                    stat = 1;
                    bf.append(ch);
                    break;
                }
                case 1: {
                    if (Character.isUpperCase(ch) || ch == '\'' || ch == '\u2019') {
                        ch = Character.toLowerCase(ch);
                    } else if (!Character.isLetter(ch) || Character.isDigit(ch)) {
                        stat = 0;
                    }
                    bf.append(ch);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            ++i;
        }
        return bf.toString();
    }

    public static String toTitleCase(CharSequence cs) {
        return Strings.toTitleCase(cs, 0, cs.length());
    }

    public static char[] toUpperCase(char[] cs, int b, int e) {
        Strings.checkRange(cs, b, e);
        int i = b;
        while (i < e) {
            cs[i] = Character.toUpperCase(cs[i]);
            ++i;
        }
        return cs;
    }

    public static char[] toLowerCase(char[] cs, int b, int e) {
        Strings.checkRange(cs, b, e);
        int i = b;
        while (i < e) {
            cs[i] = Character.toLowerCase(cs[i]);
            ++i;
        }
        return cs;
    }

    public static String toUpperCase(CharSequence cs, int b, int e) {
        StringBuilder bf = new StringBuilder();
        Strings.checkRange(cs, b, e);
        int i = b;
        while (i < e) {
            bf.append(Character.toUpperCase(cs.charAt(i)));
            ++i;
        }
        return bf.toString();
    }

    public static String toLowerCase(CharSequence cs, int b, int e) {
        StringBuilder bf = new StringBuilder();
        Strings.checkRange(cs, b, e);
        int i = b;
        while (i < e) {
            bf.append(Character.toLowerCase(cs.charAt(i)));
            ++i;
        }
        return bf.toString();
    }

    public static char[] reverse(char[] cs, int b, int e) {
        Strings.checkRange(cs, b, e);
        int i = b;
        while (i < (b + e) / 2) {
            char c = cs[i];
            cs[i] = cs[b + e - i - 1];
            cs[b + e - i - 1] = c;
            ++i;
        }
        return cs;
    }

    public static String reverse(String cs, int b, int e) {
        try {
            return new String(Strings.reverse(cs.toCharArray(), b, e));
        }
        catch (ArrayIndexOutOfBoundsException e1) {
            throw new StringIndexOutOfBoundsException(e1.getMessage());
        }
    }

    private static int mod(int x, int m) {
        int r = x % m;
        return r < 0 ? r + m : r;
    }

    public static String xsubstring(CharSequence cs, int from, int to, int b, int e) {
        StringBuilder bl = new StringBuilder();
        Strings.checkRange(cs, b, e);
        int i = from;
        while (i < to) {
            bl.append(cs.charAt(Strings.mod(i, e - b) + b));
            ++i;
        }
        return bl.toString();
    }

    public static char[] xcopy(char[] tg, int ts, CharSequence cs, int from, int to, int b, int e) {
        Strings.checkRange(cs, b, e);
        if (to - from + ts > tg.length) {
            throw new IllegalArgumentException();
        }
        if (ts >= tg.length) {
            throw new ArrayIndexOutOfBoundsException(ts);
        }
        int i = from;
        int j = ts;
        while (i < to) {
            tg[j] = cs.charAt(Strings.mod(i, e - b) + b);
            ++i;
            ++j;
        }
        return tg;
    }

    public static String replace(CharSequence s1, CharSequence s2, int b1, int e1, int b2, int e2) {
        StringBuilder bf = new StringBuilder();
        bf.append(s1.subSequence(0, b1));
        bf.append(s2.subSequence(b2, e2));
        bf.append(s1.subSequence(e1, s1.length()));
        return bf.toString();
    }

    public static String[] matchRegexp(String dest, String re) {
        Pattern pt = Pattern.compile(re);
        Matcher mt = pt.matcher(dest);
        String[] res = new String[mt.groupCount() + 1];
        int i = 0;
        while (i <= mt.groupCount()) {
            res[i] = mt.group(i);
            ++i;
        }
        return res;
    }

    public static String matchRegexp(String dest, String re, int grp) {
        Pattern pt = Pattern.compile(re);
        Matcher mt = pt.matcher(dest);
        return mt.group(grp);
    }

    public static String toHyphen(CharSequence cs, int b, int e) {
        StringBuilder bf = new StringBuilder();
        int stat = 0;
        Strings.checkRange(cs, b, e);
        int i = b;
        while (i < e) {
            char ch = cs.charAt(i);
            switch (stat) {
                case 0: {
                    bf.append(Character.toLowerCase(ch));
                    stat = 1;
                    break;
                }
                case 1: {
                    if (Character.isUpperCase(ch)) {
                        bf.append('-');
                        bf.append(Character.toLowerCase(ch));
                        break;
                    }
                    bf.append(ch);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            ++i;
        }
        return bf.toString();
    }

    public static String escapeHtml(String s) {
        String r = s;
        r = r.replaceAll("&(?!#)", "&amp;");
        r = r.replaceAll("\"", "&quot;");
        r = r.replaceAll("<", "&lt;");
        r = r.replaceAll(">", "&gt;");
        return r;
    }

    public static List<String> toList(StringTokenizer tok) {
        ArrayList<String> r = new ArrayList<String>();
        while (tok.hasMoreTokens()) {
            r.add(tok.nextToken());
        }
        return r;
    }

    public static Iterator<String> toIterator(StringTokenizer tok) {
        final StringTokenizer t = tok;
        return new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return t.hasMoreTokens();
            }

            @Override
            public String next() {
                return t.nextToken();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static boolean isUpperCase(String s) {
        int i = 0;
        while (i < s.length()) {
            int c = s.codePointAt(i);
            if (!Character.isUpperCase(c)) {
                return false;
            }
            if (c > 65535) {
                ++i;
            }
            ++i;
        }
        return true;
    }

    public static boolean isLowerCase(String s) {
        int i = 0;
        while (i < s.length()) {
            int c = s.codePointAt(i);
            if (!Character.isLowerCase(c)) {
                return false;
            }
            if (c > 65535) {
                ++i;
            }
            ++i;
        }
        return true;
    }

    public static boolean isTitleCase(String s) {
        int i = 0;
        while (i < s.length()) {
            int c = s.codePointAt(i);
            if (i == 0 && !Character.isUpperCase(c) || i > 0 && !Character.isLowerCase(c)) {
                return false;
            }
            if (c > 65535) {
                ++i;
            }
            ++i;
        }
        return true;
    }
}

