/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.bc;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import net.morilib.bc.BcAssignOp;
import net.morilib.bc.BcIncDec;
import net.morilib.bc.BcLogical;
import net.morilib.bc.BcNumber;
import net.morilib.bc.BcRelop;
import net.morilib.bc.BcStringLiteral;
import net.morilib.bc.BcSymbol;
import net.morilib.bc.BcSyntaxException;

public final class BcLexer {
    public static final Object EOF = new Object();
    private PushbackReader rd;
    private Object lookahead;
    private int level;
    private boolean nl = false;

    public BcLexer(Reader rd) throws IOException {
        this.rd = new PushbackReader(rd);
        this.lookahead = this._nextToken();
        this.level = -1;
    }

    public BcLexer(String s) throws IOException {
        this(new StringReader(s));
    }

    public BcLexer(Reader rd, int level) throws IOException {
        this.rd = new PushbackReader(rd);
        this.level = level;
        this.lookahead = this._nextToken();
    }

    public Object getLookahead() {
        return this.lookahead;
    }

    public Object next() throws IOException {
        if (this.lookahead != EOF) {
            this.lookahead = this._nextToken();
        }
        return this.lookahead;
    }

    public Object restart() throws IOException {
        this.lookahead = this._nextToken();
        return this.lookahead;
    }

    public boolean eqchar(char c) throws IOException {
        if (this.checkchar(c)) {
            this.next();
            return true;
        }
        return false;
    }

    public boolean checkchar(char c) throws IOException {
        return this.getLookahead() instanceof Character && ((Character)this.getLookahead()).charValue() == c;
    }

    public void eatchar(char c) throws IOException {
        if (!this.eqchar(c)) {
            throw new BcSyntaxException();
        }
    }

    public boolean equalTo(Object o) throws IOException {
        if (this.getLookahead().equals(o)) {
            this.next();
            return true;
        }
        return false;
    }

    public boolean isSymbol(String s) throws IOException {
        Object o = this.getLookahead();
        if (!(o instanceof BcSymbol)) {
            return false;
        }
        if (o.toString().equals(s)) {
            this.next();
            return true;
        }
        return false;
    }

    public BcSymbol getSymbol() throws IOException {
        Object o = this.getLookahead();
        if (o instanceof BcSymbol) {
            this.next();
            return (BcSymbol)o;
        }
        return null;
    }

    public String eatSymbol() throws IOException {
        Object o = this.getLookahead();
        if (o instanceof BcSymbol) {
            this.next();
            return o.toString();
        }
        throw new BcSyntaxException();
    }

    public BcStringLiteral getString() throws IOException {
        Object o = this.getLookahead();
        if (o instanceof BcStringLiteral) {
            this.next();
            return (BcStringLiteral)o;
        }
        return null;
    }

    public boolean isEof() {
        return this.getLookahead() == EOF;
    }

    public BcNumber getNumber() throws IOException {
        Object o = this.getLookahead();
        if (o instanceof BcNumber) {
            this.next();
            return (BcNumber)o;
        }
        return null;
    }

    public BcRelop getRelop() throws IOException {
        Object o = this.getLookahead();
        if (o instanceof BcRelop) {
            this.next();
            return (BcRelop)((Object)o);
        }
        return null;
    }

    public BcAssignOp getAssignop() throws IOException {
        Object o = this.getLookahead();
        if (o instanceof BcAssignOp) {
            this.next();
            return (BcAssignOp)((Object)o);
        }
        return null;
    }

    public boolean checkeos() throws IOException {
        Object o = this.getLookahead();
        return o.equals(Character.valueOf(';')) || o.equals(Character.valueOf('\n'));
    }

    public void eateos() throws IOException {
        if (!this.checkeos()) {
            throw new BcSyntaxException();
        }
        this.next();
    }

    public void skipnl() throws IOException {
        while (!this.isEof() && this.getLookahead().equals(Character.valueOf('\n'))) {
            this.next();
        }
        this.nl = false;
    }

    public void incLevel() {
        if (this.level >= 0) {
            ++this.level;
        }
    }

    public void decLevel() {
        if (this.level > 0) {
            --this.level;
        }
    }

    public void setnl() {
        this.nl = true;
    }

    Object _nextToken() throws IOException {
        StringBuffer b = null;
        S1 stat = S1.INIT;
        block30: while (true) {
            int c = this.rd.read();
            switch (stat) {
                case INIT: {
                    if (c < 0) {
                        return EOF;
                    }
                    if (c >= 48 && c <= 57 || c >= 65 && c <= 70) {
                        b = new StringBuffer();
                        b.append((char)c);
                        stat = S1.NUM1;
                        continue block30;
                    }
                    if (c == 46) {
                        stat = S1.DOT1;
                        continue block30;
                    }
                    if (c == 60) {
                        stat = S1.LESS;
                        continue block30;
                    }
                    if (c == 62) {
                        stat = S1.MORE;
                        continue block30;
                    }
                    if (c == 61) {
                        stat = S1.EQUL;
                        continue block30;
                    }
                    if (c == 33) {
                        stat = S1.EXCL;
                        continue block30;
                    }
                    if (c == 43) {
                        stat = S1.PLUS;
                        continue block30;
                    }
                    if (c == 45) {
                        stat = S1.MINS;
                        continue block30;
                    }
                    if (c == 42) {
                        stat = S1.ASTR;
                        continue block30;
                    }
                    if (c == 47) {
                        stat = S1.SLAS;
                        continue block30;
                    }
                    if (c == 37) {
                        stat = S1.PERC;
                        continue block30;
                    }
                    if (c == 94) {
                        stat = S1.CART;
                        continue block30;
                    }
                    if (c == 38) {
                        stat = S1.AMPS;
                        continue block30;
                    }
                    if (c == 124) {
                        stat = S1.VERT;
                        continue block30;
                    }
                    if (c == 10) {
                        if (this.nl) {
                            this.nl = false;
                            return Character.valueOf('\n');
                        }
                        if (this.level == 0) {
                            return EOF;
                        }
                        return Character.valueOf('\n');
                    }
                    if (c != 10 && Character.isWhitespace(c)) continue block30;
                    if (Character.isJavaIdentifierStart(c)) {
                        b = new StringBuffer();
                        b.append((char)c);
                        stat = S1.SYM1;
                        continue block30;
                    }
                    if (c == 34) {
                        b = new StringBuffer();
                        stat = S1.STR1;
                        continue block30;
                    }
                    if (c == 123) {
                        if (this.level >= 0) {
                            ++this.level;
                        }
                    } else if (c == 125 && this.level > 0) {
                        --this.level;
                    }
                    this.nl = this.nl && c != 125;
                    return Character.valueOf((char)c);
                }
                case NUM1: {
                    if (c >= 48 && c <= 57 || c >= 65 && c <= 70) {
                        b.append((char)c);
                        continue block30;
                    }
                    if (c == 46) {
                        b.append((char)c);
                        stat = S1.NUM2;
                        continue block30;
                    }
                    if (c >= 0) {
                        this.rd.unread(c);
                    }
                    return new BcNumber(b.toString());
                }
                case NUM2: {
                    if (c >= 48 && c <= 57 || c >= 65 && c <= 70) {
                        b.append((char)c);
                        stat = S1.NUM3;
                        continue block30;
                    }
                    throw new BcSyntaxException();
                }
                case NUM3: {
                    if (c >= 48 && c <= 57 || c >= 65 && c <= 70) {
                        b.append((char)c);
                        continue block30;
                    }
                    if (c >= 0) {
                        this.rd.unread(c);
                    }
                    return new BcNumber(b.toString());
                }
                case LESS: {
                    if (c == 61) {
                        return BcRelop.LE;
                    }
                    if (c >= 0) {
                        this.rd.unread(c);
                    }
                    return BcRelop.LT;
                }
                case MORE: {
                    if (c == 61) {
                        return BcRelop.GE;
                    }
                    if (c >= 0) {
                        this.rd.unread(c);
                    }
                    return BcRelop.GT;
                }
                case EQUL: {
                    if (c == 61) {
                        return BcRelop.EQ;
                    }
                    if (c >= 0) {
                        this.rd.unread(c);
                    }
                    return BcAssignOp.SIMPLE;
                }
                case EXCL: {
                    if (c == 61) {
                        return BcRelop.NE;
                    }
                    if (c >= 0) {
                        this.rd.unread(c);
                    }
                    return Character.valueOf('!');
                }
                case PLUS: {
                    if (c == 61) {
                        return BcAssignOp.ADD;
                    }
                    if (c == 43) {
                        return BcIncDec.INC;
                    }
                    if (c >= 0) {
                        this.rd.unread(c);
                    }
                    return Character.valueOf('+');
                }
                case MINS: {
                    if (c == 61) {
                        return BcAssignOp.SUB;
                    }
                    if (c == 45) {
                        return BcIncDec.DEC;
                    }
                    if (c >= 0) {
                        this.rd.unread(c);
                    }
                    return Character.valueOf('-');
                }
                case ASTR: {
                    if (c == 61) {
                        return BcAssignOp.MUL;
                    }
                    if (c >= 0) {
                        this.rd.unread(c);
                    }
                    return Character.valueOf('*');
                }
                case SLAS: {
                    if (c == 61) {
                        return BcAssignOp.DIV;
                    }
                    if (c == 42) {
                        stat = S1.COM1;
                        continue block30;
                    }
                    if (c >= 0) {
                        this.rd.unread(c);
                    }
                    return Character.valueOf('/');
                }
                case PERC: {
                    if (c == 61) {
                        return BcAssignOp.MOD;
                    }
                    if (c >= 0) {
                        this.rd.unread(c);
                    }
                    return Character.valueOf('%');
                }
                case CART: {
                    if (c == 61) {
                        return BcAssignOp.POW;
                    }
                    if (c >= 0) {
                        this.rd.unread(c);
                    }
                    return Character.valueOf('^');
                }
                case COM1: {
                    if (c < 0) {
                        throw new BcSyntaxException();
                    }
                    if (c != 42) continue block30;
                    stat = S1.COM2;
                    continue block30;
                }
                case COM2: {
                    if (c < 0) {
                        throw new BcSyntaxException();
                    }
                    stat = c == 47 ? S1.INIT : (c == 42 ? S1.COM2 : S1.COM1);
                    continue block30;
                }
                case SYM1: {
                    if (Character.isJavaIdentifierPart(c)) {
                        b.append((char)c);
                        continue block30;
                    }
                    if (c >= 0) {
                        this.rd.unread(c);
                    }
                    return new BcSymbol(b.toString());
                }
                case STR1: {
                    if (c < 0) {
                        throw new BcSyntaxException();
                    }
                    if (c == 34) {
                        return new BcStringLiteral(b.toString());
                    }
                    if (c == 92) {
                        stat = S1.STR2;
                        continue block30;
                    }
                    b.append((char)c);
                    continue block30;
                }
                case STR2: {
                    if (c < 0) {
                        throw new BcSyntaxException();
                    }
                    switch (c) {
                        case 110: {
                            b.append('\n');
                            break;
                        }
                        case 114: {
                            b.append('\r');
                            break;
                        }
                        case 116: {
                            b.append('\t');
                            break;
                        }
                        default: {
                            b.append((char)c);
                        }
                    }
                    stat = S1.STR1;
                    continue block30;
                }
                case AMPS: {
                    if (c == 38) {
                        return BcLogical.AND;
                    }
                    this.rd.unread(c);
                    return Character.valueOf('&');
                }
                case VERT: {
                    if (c == 124) {
                        return BcLogical.OR;
                    }
                    this.rd.unread(c);
                    return Character.valueOf('|');
                }
                case DOT1: {
                    if (c == 46) {
                        stat = S1.DOT2;
                        continue block30;
                    }
                    if (c >= 48 && c <= 57 || c >= 65 && c <= 70) {
                        b = new StringBuffer();
                        b.append('0').append((char)c);
                        stat = S1.NUM2;
                        continue block30;
                    }
                    throw new BcSyntaxException();
                }
                case DOT2: {
                    if (c == 46) continue block30;
                    this.rd.unread(c);
                    return new BcSymbol("...");
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum S1 {
        INIT,
        NUM1,
        NUM2,
        NUM3,
        LESS,
        MORE,
        EQUL,
        EXCL,
        PLUS,
        MINS,
        ASTR,
        SLAS,
        PERC,
        CART,
        COM1,
        COM2,
        SYM1,
        STR1,
        STR2,
        AMPS,
        VERT,
        DOT1,
        DOT2;

    }
}

