/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.dc.number;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import net.morilib.dc.number.AbstractNumerical;
import net.morilib.dc.number.Integer2;
import net.morilib.dc.number.NumericalFieldElement;
import net.morilib.dc.number.QuotientAndRemainder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Rational
extends AbstractNumerical<Rational>
implements NumericalFieldElement<Rational> {
    private static final int EMAX = 2047;
    private static final int EXPBIT = 52;
    private static final long EXPMASK = 0x7FF0000000000000L;
    private static final long SIGMASK = 0xFFFFFFFFFFFFFL;
    private static final long SGNMASK = Long.MIN_VALUE;
    private static final int MAX_EXPONENT = 1023;
    private static final int MIN_EXPONENT = -1074;
    private static final int MIN_NORMALIZED_EXPONENT = -1022;
    private static final int FRACTION_BITS = 52;
    private static final int BIAS = 1023;
    private Integer2 numer;
    private Integer2 denom;
    public static final Rational ZERO = new Rational(Integer2.ZERO, Integer2.ONE);
    public static final Rational ONE = new Rational(Integer2.ONE, Integer2.ONE);

    private Rational(Integer2 num, Integer2 den) {
        this.numer = num;
        this.denom = den;
    }

    public static final Rational valueOf(Integer2 num, Integer2 den) {
        Integer2 n = num;
        Integer2 d = den;
        int nsig = num.signum();
        int dsig = den.signum();
        if (dsig == 0) {
            throw new ArithmeticException("denominator is zero");
        }
        if (nsig == 0) {
            return ZERO;
        }
        if (dsig < 0) {
            n = (Integer2)n.negate();
            d = (Integer2)d.negate();
        }
        Integer2 gcd = Integer2.valueOf(n.toBigInteger().gcd(d.toBigInteger()));
        n = n.divide(gcd);
        d = d.divide(gcd);
        return new Rational(n, d);
    }

    /*
     * Unable to fully structure code
     */
    private static int gcd(int v1, int v2) {
        x = v1 < 0 ? -v1 : v1;
        v0 = y = v2 < 0 ? -v2 : v2;
        if (x != 0 || y != 0) ** GOTO lbl8
        return 0;
lbl-1000:
        // 1 sources

        {
            t = x % y;
            x = y;
            y = t;
lbl8:
            // 2 sources

            ** while (y != 0)
        }
lbl9:
        // 1 sources

        return x;
    }

    public static final Rational valueOf(int num, int den) {
        int n1 = num;
        int d1 = den;
        if (d1 == 0) {
            throw new ArithmeticException("denominator is zero");
        }
        if (n1 == 0) {
            return ZERO;
        }
        if (d1 < 0) {
            n1 = -n1;
            d1 = -d1;
        }
        int gcd = Rational.gcd(n1, d1);
        return new Rational(Integer2.valueOf(n1 /= gcd), Integer2.valueOf(d1 /= gcd));
    }

    public static final Rational valueOf(int num) {
        return Rational.valueOf(num, 1);
    }

    public static Rational valueOf(BigDecimal v) {
        BigInteger n = v.unscaledValue();
        if (v.scale() > 0) {
            BigInteger d = BigInteger.TEN.pow(v.scale());
            return Rational.valueOf(Integer2.valueOf(n), Integer2.valueOf(d));
        }
        if (v.scale() < 0) {
            BigInteger d = BigInteger.TEN.pow(-v.scale());
            return Rational.valueOf(Integer2.valueOf(n.multiply(d)), Integer2.ONE);
        }
        return Rational.valueOf(Integer2.valueOf(n), Integer2.ONE);
    }

    private static int getExponentField(long x) {
        return (int)((x & 0x7FF0000000000000L) >> 52);
    }

    private static long getFractionField(long x) {
        return x & 0xFFFFFFFFFFFFFL;
    }

    private static boolean isZero(long x) {
        return (x & Long.MAX_VALUE) == 0L;
    }

    private static int getExponent(double d) {
        long x = Double.doubleToLongBits(d);
        int e = Rational.getExponentField(x);
        long f = Rational.getFractionField(x);
        if (Rational.isZero(x)) {
            return 0;
        }
        if (e == 2047) {
            if (f == 0L) {
                return 1024;
            }
            return Integer.MIN_VALUE;
        }
        if (e > 0) {
            return e - 1023;
        }
        return -1074 + (Rational.getMsb(f) - 1);
    }

    private static int _getLsb(long x, int s, int e) {
        if (s == e) {
            return s + 1;
        }
        int c = (e - s >> 1) + s;
        int m = (1 << (e - s >> 1) + 1) - 1 << s;
        if ((x & (long)m) != 0L) {
            return Rational._getLsb(x, s, c);
        }
        return Rational._getLsb(x, c + 1, e);
    }

    private static int getLsb(long x) {
        return x == 0L ? 0 : Rational._getLsb(x, 0, 63);
    }

    private static int _getMsb(long x, int s, int e) {
        if (s == e) {
            return s;
        }
        int c = (e - s >> 1) + s;
        int m = (1 << (e - s >> 1) + 1) - 1 << c;
        if ((x & (long)m) != 0L) {
            return Rational._getMsb(x, c + 1, e);
        }
        return Rational._getMsb(x, s, c);
    }

    private static int getMsb(long x) {
        return x == 0L ? 0 : Rational._getMsb(x, 0, 63);
    }

    public static Rational valueOf(double val) {
        Integer2 n;
        Integer2 d;
        if (Double.isInfinite(val) || Double.isNaN(val)) {
            throw new ArithmeticException("Infinity and NaN is not supported");
        }
        int e = Rational.getExponent(val);
        long f = Rational.getExponent(val);
        if (val == 0.0) {
            return ZERO;
        }
        if (f == 0L) {
            if (e >= 0) {
                d = Integer2.ONE;
                n = (Integer2)Integer2.valueOf(2).power(e);
            } else {
                d = (Integer2)Integer2.valueOf(2).power(-e);
                n = Integer2.ONE;
            }
        } else if (e >= -1022) {
            int m = Rational.getLsb(f) - 1;
            int t = 52 - m;
            f |= 0x100000L;
            if (e - t >= 0) {
                d = Integer2.ONE;
                n = (Integer2)Integer2.valueOf(2).power(e - t);
                n = n.multiply(Integer2.valueOf(f >> m));
            } else {
                d = (Integer2)Integer2.valueOf(2).power(t - e);
                n = Integer2.valueOf(f >> m);
            }
        } else {
            d = (Integer2)Integer2.valueOf(2).power(-1074);
            n = Integer2.valueOf(f);
        }
        return Rational.valueOf(n, d);
    }

    public static Rational valueOf(BigInteger b) {
        return new Rational(Integer2.valueOf(b), Integer2.ONE);
    }

    public static BigDecimal toBigDecimal(Rational r) {
        BigDecimal n = new BigDecimal(r.numer.toBigInteger());
        BigDecimal d = new BigDecimal(r.denom.toBigInteger());
        return n.divide(d);
    }

    public static BigDecimal toBigDecimal(Rational r, MathContext mc) {
        BigDecimal n = new BigDecimal(r.numer.toBigInteger());
        BigDecimal d = new BigDecimal(r.denom.toBigInteger());
        return n.divide(d, mc);
    }

    public static BigDecimal toBigDecimal(Rational r, int scale, RoundingMode mode) {
        BigDecimal n = new BigDecimal(r.numer.toBigInteger());
        BigDecimal d = new BigDecimal(r.denom.toBigInteger());
        return n.divide(d, scale, mode);
    }

    public static Rational rationalize(Rational r1, Rational r2) {
        Integer2 c;
        Integer2 d;
        Rational y;
        Rational e = r2.compareTo(ZERO) < 0 ? r2.negate() : r2;
        Rational x = r1.add(e);
        if (x.equals(y = r1.subtract(e))) {
            return x;
        }
        Integer2 xn = x.numer;
        Integer2 xd = x.denom;
        Integer2 yn = y.numer;
        Integer2 yd = y.denom;
        Integer2 a = d = Integer2.ONE;
        Integer2 b = c = Integer2.ZERO;
        while (true) {
            QuotientAndRemainder<Integer2> qx = xn.divideAndRemainder(xd);
            QuotientAndRemainder<Integer2> qy = yn.divideAndRemainder(yd);
            Integer2 xq = qx.getQuotient();
            if (qx.getRemainder().isZero()) {
                return Rational.valueOf(a.multiply(xq).add(b), c.multiply(xq).add(d));
            }
            if (xq.compareTo(qy.getQuotient()) < 0) {
                return Rational.valueOf(a.multiply(xq.add(Integer2.ONE)).add(b), c.multiply(xq.add(Integer2.ONE)).add(d));
            }
            if (xq.compareTo(qy.getQuotient()) > 0) {
                throw new RuntimeException("implementation error");
            }
            Integer2 aa = a;
            Integer2 cc = c;
            a = a.multiply(xq).add(b);
            b = aa;
            c = c.multiply(xq).add(d);
            d = cc;
            xn = yd;
            yn = xd;
            xd = qy.getRemainder();
            yd = qx.getRemainder();
        }
    }

    public Integer2 getNumerator() {
        return this.numer;
    }

    public Integer2 getDenominator() {
        return this.denom;
    }

    public Integer2 getIntegerPart() {
        return this.numer.divide(this.denom);
    }

    @Override
    public Rational add(Rational n) {
        Integer2 nd = this.denom.multiply(n.denom);
        Integer2 nn = this.numer.multiply(n.denom).add(n.numer.multiply(this.denom));
        return Rational.valueOf(nn, nd);
    }

    @Override
    public Rational divide(Rational n) {
        Integer2 nd = this.denom.multiply(n.numer);
        Integer2 nn = this.numer.multiply(n.denom);
        return Rational.valueOf(nn, nd);
    }

    public boolean isEqualTo(Rational n) {
        return this.numer.equals(n.numer) && this.denom.equals(n.denom);
    }

    @Override
    public Rational multiply(Rational n) {
        Integer2 nd = this.denom.multiply(n.denom);
        Integer2 nn = this.numer.multiply(n.numer);
        return Rational.valueOf(nn, nd);
    }

    @Override
    public Rational subtract(Rational n) {
        Integer2 nd = this.denom.multiply(n.denom);
        Integer2 nn = this.numer.multiply(n.denom).subtract(n.numer.multiply(this.denom));
        return Rational.valueOf(nn, nd);
    }

    @Override
    public Rational negate() {
        return new Rational((Integer2)this.numer.negate(), this.denom);
    }

    public int signum() {
        return this.numer.signum();
    }

    @Override
    public boolean isUnit() {
        return this.numer.equals(Integer2.ONE) && this.denom.equals(Integer2.ONE);
    }

    public boolean isZero() {
        return this.isEqualTo(ZERO);
    }

    @Override
    public Rational multiply(int n) {
        Integer2 nn = (Integer2)this.numer.multiply(n);
        return Rational.valueOf(nn, this.denom);
    }

    @Override
    public Rational power(int n) {
        Integer2 nd = (Integer2)this.denom.power(n);
        Integer2 nn = (Integer2)this.numer.power(n);
        return Rational.valueOf(nn, nd);
    }

    @Override
    public Rational invert() {
        return Rational.valueOf(this.denom, this.numer);
    }

    @Override
    public double doubleValue() {
        return this.numer.doubleValue() / this.denom.doubleValue();
    }

    @Override
    public float floatValue() {
        return this.numer.floatValue() / this.denom.floatValue();
    }

    @Override
    public int castInt() {
        return this.castInteger2().toInt();
    }

    @Override
    public long castLong() {
        return this.castInteger2().toLong();
    }

    @Override
    public Integer2 castInteger2() {
        return this.numer.divide(this.denom);
    }

    @Override
    public Integer2 getInteger2Floor() {
        QuotientAndRemainder<Integer2> r0 = this.numer.divideAndRemainder(this.denom);
        if (r0.getRemainder().equals(Integer2.ZERO)) {
            return r0.getQuotient();
        }
        if (this.numer.signum() > 0 ^ this.denom.signum() > 0) {
            return r0.getQuotient();
        }
        return r0.getQuotient().subtract(Integer2.ONE);
    }

    @Override
    public int intFloor() {
        return this.getInteger2Floor().toInt();
    }

    @Override
    public long longFloor() {
        return this.getInteger2Floor().toLong();
    }

    @Override
    public Integer2 getInteger2Ceil() {
        QuotientAndRemainder<Integer2> r0 = this.numer.divideAndRemainder(this.denom);
        if (r0.getRemainder().equals(Integer2.ZERO)) {
            return r0.getQuotient();
        }
        if (this.numer.signum() > 0 ^ this.denom.signum() > 0) {
            return r0.getQuotient().add(Integer2.ONE);
        }
        return r0.getQuotient();
    }

    @Override
    public int intCeil() {
        return this.getInteger2Ceil().toInt();
    }

    @Override
    public long longCeil() {
        return this.getInteger2Ceil().toLong();
    }

    @Override
    public boolean isInteger() {
        return this.denom.equals(Integer2.ONE);
    }

    @Override
    public int compareTo(Rational o) {
        Integer2 c = this.numer.multiply(o.denom);
        Integer2 d = o.numer.multiply(this.denom);
        return c.compareTo(d);
    }

    @Override
    public Rational getRational() {
        return this;
    }

    public boolean equals(Object x) {
        if (x instanceof Rational) {
            Rational n = (Rational)x;
            return this.numer.equals(n.numer) && this.denom.equals(n.denom);
        }
        return false;
    }

    public int hashCode() {
        int l = 17;
        l = 37 * l + this.numer.hashCode();
        l = 37 * l + this.denom.hashCode();
        return l;
    }

    public String toString() {
        if (this.numer.isZero()) {
            return "0";
        }
        if (this.denom.isUnit()) {
            return this.numer.toString();
        }
        return String.valueOf(this.numer.toString()) + "/" + this.denom.toString();
    }
}

