/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sh;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShFile;
import net.morilib.sh.ShFileSystem;
import net.morilib.sh.ShFiles;
import net.morilib.sh.ShRuntime;
import net.morilib.sh.ShSyntaxException;
import net.morilib.sh.ShToken;
import net.morilib.sh.ShTree;
import net.morilib.sh.ShTreeExpressionMachine;
import net.morilib.sh.ShTrees;
import net.morilib.sh.builtin.ShBuiltInCommands;
import net.morilib.sh.misc.XtraceStream;

public class ShTreeType
implements ShTree {
    private ShToken var;

    public ShTreeType(ShToken var) {
        this.var = var;
    }

    public int eval(ShEnvironment env, ShFileSystem fs, ShBuiltInCommands cmds, ShRuntime run, InputStream in, PrintStream out, PrintStream err, XtraceStream p) throws IOException, ShSyntaxException {
        String s = ShTrees.substitute(env, run, fs, err, p, this.var);
        if (env.findFunction(s) != null) {
            out.print(s);
            out.println(" is a function");
        } else if (cmds.find(s) != null) {
            out.print(s);
            out.println(" is a shell builtin");
        } else if (s.equals("break") || s.equals("continue") || s.equals("return") || s.equals(".") || s.equals("source") || s.equals("type") || s.equals("eval") || s.equals("builtin") || s.equals("command") || s.equals("sh")) {
            out.print(s);
            out.println(" is a shell builtin");
        } else {
            ShFile f = ShFiles.searchPath(env, fs, s);
            if (f != null) {
                out.print(s);
                out.print(" is ");
                out.println(f.toString());
            } else {
                out.print(s);
                out.println(" not found");
            }
        }
        return 0;
    }

    public void compileInternally(ShTreeExpressionMachine.Builder b, Object brk, Object cnt) {
        b.add(this);
    }
}

