/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sh.builtin;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShFileSystem;
import net.morilib.sh.ShProcess;

public class ShSleep
implements ShProcess {
    private static final Pattern FMT = Pattern.compile("([0-9]+)([smhd]?)");

    public int main(ShEnvironment env, ShFileSystem fs, InputStream in, PrintStream out, PrintStream err, String ... args) throws IOException {
        Matcher m;
        if (args.length < 2 || !(m = FMT.matcher(args[1])).matches()) {
            err.println("sleep: illegal argument");
            return 2;
        }
        long t = Long.parseLong(m.group(1));
        if (m.group(2).equals("m")) {
            t *= 60L;
        } else if (m.group(2).equals("h")) {
            t *= 3600L;
        } else if (m.group(2).equals("d")) {
            t *= 86400L;
        }
        try {
            Thread.sleep(t * 1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return 0;
    }
}

