/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sh.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.TreeSet;
import net.morilib.sh.ShFile;
import net.morilib.sh.ShFileSystem;
import net.morilib.sh.ShProcess;
import net.morilib.sh.ShStat;
import net.morilib.sh.file.ShUnixRealFile;
import net.morilib.sh.misc.FileTypeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShRealFile
implements ShFile {
    protected ShFileSystem filesystem;
    protected String virtualpath;
    protected File file;

    public ShRealFile(ShFileSystem fs, String virtualpath, File file) {
        this.filesystem = fs;
        this.virtualpath = virtualpath;
        this.file = file;
    }

    @Override
    public Collection<ShFile> getFiles() {
        ArrayList<ShFile> l = new ArrayList<ShFile>();
        TreeSet<String> z = new TreeSet<String>(Arrays.asList(this.file.list()));
        for (String s : z) {
            ShFile f = this.filesystem.getFile(this.virtualpath, s);
            l.add(f);
        }
        return l;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public PrintStream getPrintStream(boolean append) throws IOException {
        return new PrintStream(new FileOutputStream(this.file, append));
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    @Override
    public boolean isExecutable() {
        if (this.file.isDirectory()) {
            return true;
        }
        if (this.file.isFile()) {
            return FileTypeUtils.parseShebang(this) != null;
        }
        return false;
    }

    @Override
    public boolean isExist() {
        return this.file.exists();
    }

    @Override
    public boolean isFile() {
        return this.file.isFile();
    }

    @Override
    public long getLastModified() {
        return this.file.lastModified();
    }

    @Override
    public boolean isReadable() {
        return this.file.canRead();
    }

    @Override
    public boolean isWritable() {
        return this.file.canWrite();
    }

    @Override
    public boolean isHidden() {
        return this.file.isHidden();
    }

    @Override
    public boolean isZeroFile() {
        return this.file.length() == 0L;
    }

    @Override
    public ShFile toAbsolute() {
        if (this.virtualpath.length() > 0 && this.virtualpath.charAt(0) == '/') {
            return this.filesystem.getFile(this.virtualpath);
        }
        return this.filesystem.getFile(this.filesystem.getCurrentDirectory().toString(), this.virtualpath);
    }

    @Override
    public boolean mkdir() {
        return this.file.mkdir();
    }

    @Override
    public boolean renameTo(ShFile f) {
        if (f instanceof ShUnixRealFile) {
            this.file.renameTo(((ShRealFile)f).file);
            return true;
        }
        return false;
    }

    @Override
    public void setLastModified(long time) {
        this.file.setLastModified(time);
    }

    @Override
    public boolean rmdir() {
        return this.file.isDirectory() && this.file.delete();
    }

    @Override
    public boolean deleteFile() {
        return this.file.isFile() && this.file.delete();
    }

    @Override
    public ShStat getStat() {
        ShStat r = new ShStat();
        int f = 0;
        r.setFilename(this.virtualpath);
        r.setMtime(this.file.lastModified());
        r.setSize(this.file.length());
        f |= this.isDirectory() ? 8 : 0;
        f |= this.isExecutable() ? 4 : 0;
        f |= this.isWritable() ? 2 : 0;
        r.setFlags(f |= this.isReadable() ? 1 : 0);
        return r;
    }

    @Override
    public ShProcess getProcess(String ... args) {
        return null;
    }

    public String toString() {
        return this.virtualpath;
    }
}

