/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sh.misc;

import java.io.IOException;
import java.io.InputStream;

public class ConsoleInputStream
extends InputStream {
    private byte[] line = null;
    private int point;

    ConsoleInputStream() {
    }

    public static InputStream console() {
        if (System.console() != null) {
            return new ConsoleInputStream();
        }
        return System.in;
    }

    public int read() {
        if (this.line == null) {
            this.point = 0;
            this.line = System.console().readLine().getBytes();
            return this.read();
        }
        if (this.point < this.line.length) {
            return this.line[this.point++];
        }
        this.line = null;
        return 10;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int i = 0;
        while (i < len) {
            int c = this.read();
            if (c < 0) {
                return i;
            }
            b[i] = (byte)c;
            if (c == 10) {
                return i + 1;
            }
            ++i;
        }
        return len;
    }

    public void close() {
    }
}

