/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.matrix;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.morilib.awk.matrix.AwkMatrixException;
import net.morilib.awk.matrix.DoubleVector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayDoubleVector
implements DoubleVector {
    private double[] array;

    public ArrayDoubleVector(int size) {
        this(size, 0.0);
    }

    public ArrayDoubleVector(int size, double fill) {
        this.array = new double[size];
        Arrays.fill(this.array, fill);
    }

    ArrayDoubleVector(double ... nums) {
        this.array = nums;
    }

    public static ArrayDoubleVector newInstance(double ... nums) {
        double[] c = new double[nums.length];
        System.arraycopy(nums, 0, c, 0, nums.length);
        return new ArrayDoubleVector(c);
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    public double get(int index) {
        return this.array[index];
    }

    @Override
    public void set(int index, double x) {
        this.array[index] = x;
    }

    @Override
    public DoubleVector mul(double x) {
        ArrayDoubleVector r = new ArrayDoubleVector(this.array.length);
        int i = 0;
        while (i < this.array.length) {
            r.array[i] = this.array[i] * x;
            ++i;
        }
        return r;
    }

    @Override
    public DoubleVector add(DoubleVector v) {
        ArrayDoubleVector r = new ArrayDoubleVector(this.array.length);
        if (this.array.length != v.size()) {
            throw new AwkMatrixException("cannot add the vector");
        }
        int i = 0;
        while (i < this.array.length) {
            r.array[i] = this.array[i] + v.get(i);
            ++i;
        }
        return r;
    }

    @Override
    public DoubleVector sub(DoubleVector v) {
        ArrayDoubleVector r = new ArrayDoubleVector(this.array.length);
        if (this.array.length != v.size()) {
            throw new AwkMatrixException("cannot subtract the vector");
        }
        int i = 0;
        while (i < this.array.length) {
            r.array[i] = this.array[i] - v.get(i);
            ++i;
        }
        return r;
    }

    @Override
    public DoubleVector uminus() {
        ArrayDoubleVector r = new ArrayDoubleVector(this.array.length);
        int i = 0;
        while (i < this.array.length) {
            r.array[i] = -this.array[i];
            ++i;
        }
        return r;
    }

    public Iterator<Double> iterator() {
        return new Iterator<Double>(){
            private int p = 0;

            @Override
            public boolean hasNext() {
                return this.p < ArrayDoubleVector.this.array.length;
            }

            @Override
            public Double next() {
                if (this.p >= ArrayDoubleVector.this.array.length) {
                    throw new NoSuchElementException();
                }
                return ArrayDoubleVector.this.array[this.p++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public double innerProduct(DoubleVector b) throws AwkMatrixException {
        if (b.size() != this.size()) {
            throw new AwkMatrixException("size of the vectors are different");
        }
        double x = 0.0;
        int i = 0;
        while (i < this.size()) {
            x += this.get(i) * b.get(i);
            ++i;
        }
        return x;
    }

    @Override
    public double normSquared() {
        double x = 0.0;
        int i = 0;
        while (i < this.size()) {
            x += this.get(i) * this.get(i);
            ++i;
        }
        return x;
    }

    @Override
    public boolean isEqualTo(DoubleVector y) {
        if (this.size() == y.size()) {
            int i = 0;
            while (i < this.size()) {
                if (this.get(i) != y.get(i)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }
}

