/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.misc;

import java.math.BigInteger;
import net.morilib.awk.misc.Math2;
import net.morilib.awk.value.AwkComplex;
import net.morilib.awk.value.AwkFloat;
import net.morilib.awk.value.AwkInteger;
import net.morilib.awk.value.AwkValue;

public final class AwkComplexMath {
    private static final AwkValue I = AwkComplex.valueOf(0.0, 1.0);
    private static final AwkValue TWO_I = AwkComplex.valueOf(0.0, 2.0);
    private static final Double P_ZERO = new Double(0.0);
    private static final Double M_ZERO = new Double(-0.0);
    public static final AwkValue INEXACT_PI = AwkFloat.valueOf(Math.PI);

    private AwkComplexMath() {
    }

    private static AwkValue exptC(AwkValue nm1, AwkValue nm2) {
        double a1 = nm1.toFloat();
        double b1 = nm1.toImaginary();
        double r1 = Math.hypot(a1, b1);
        double t1 = Math.atan2(b1, a1);
        double a2 = nm2.toFloat();
        double b2 = nm2.toImaginary();
        double rr = a2 * Math.log(r1) - t1 * b2;
        double tr = b2 * Math.log(r1) + t1 * a2;
        return AwkComplex.valueOf(Math.exp(rr) * Math.cos(tr), Math.exp(rr) * Math.sin(tr));
    }

    public static boolean isPlusZero(double r) {
        return r == 0.0 && P_ZERO.equals(new Double(r));
    }

    public static boolean isMinusZero(double r) {
        return r == 0.0 && M_ZERO.equals(new Double(r));
    }

    public static AwkValue expt(AwkValue nm1, AwkValue nm2) {
        if (nm1.isNaN() || nm2.isNaN()) {
            return AwkFloat.NaN;
        }
        if (nm2.isZeroValue()) {
            if (nm1.isInteger() && nm2.isInteger()) {
                return AwkInteger.valueOf(1L);
            }
            return AwkFloat.valueOf(1.0);
        }
        if (nm1.isZeroValue()) {
            if (nm1.isInteger() && nm2.isInteger()) {
                return AwkInteger.valueOf(0L);
            }
            return AwkFloat.valueOf(0.0);
        }
        if (nm1.isOne()) {
            if (nm1.isInteger() && nm2.isInteger()) {
                return AwkInteger.valueOf(1L);
            }
            return AwkFloat.valueOf(1.0);
        }
        if (nm2.isOne()) {
            if (nm1.isInteger() && nm2.isInteger()) {
                return nm1;
            }
            return AwkFloat.valueOf(nm1.toFloat());
        }
        if (nm2.isComplex()) {
            return AwkComplexMath.exptC(nm1, nm2);
        }
        if (nm1.isComplex()) {
            return AwkComplexMath.expt(nm1, nm2.toFloat());
        }
        if (nm1.toFloat() > 0.0) {
            return AwkFloat.valueOf(Math.pow(nm1.toFloat(), nm2.toFloat()));
        }
        return AwkComplexMath.expt(nm1, nm2.toFloat());
    }

    public static AwkValue expt(AwkValue nm1, double r) {
        double a1 = nm1.toFloat();
        double b1 = nm1.toImaginary();
        if (nm1.isNaN() || Double.isNaN(r)) {
            return AwkFloat.NaN;
        }
        if (b1 == 0.0 && a1 == 1.0) {
            return AwkFloat.valueOf(1.0);
        }
        if (r == Double.POSITIVE_INFINITY) {
            double r1 = Math.hypot(a1, b1);
            if (r1 < 1.0 && r1 > -1.0) {
                return AwkFloat.valueOf(0.0);
            }
            if (b1 == 0.0 && a1 > 1.0) {
                return AwkFloat.valueOf(Double.POSITIVE_INFINITY);
            }
            return AwkFloat.NaN;
        }
        if (r == Double.NEGATIVE_INFINITY) {
            double r1 = Math.hypot(a1, b1);
            if (r1 > 1.0 || r1 < -1.0) {
                return AwkFloat.valueOf(0.0);
            }
            if (b1 == 0.0 && a1 < 1.0 && a1 > 0.0) {
                return AwkFloat.valueOf(Double.POSITIVE_INFINITY);
            }
            return AwkFloat.NaN;
        }
        if (b1 == 0.0 && a1 > 0.0) {
            return AwkFloat.valueOf(Math.pow(a1, r));
        }
        double r1 = Math.hypot(a1, b1);
        double t1 = Math.atan2(b1, a1);
        double a2 = r;
        double rr = a2 * Math.log(r1);
        double tr = t1 * a2;
        return AwkComplex.valueOf(Math.exp(rr) * Math.cos(tr), Math.exp(rr) * Math.sin(tr));
    }

    public static AwkValue sqrt(AwkValue n) {
        if (n.isZeroValue()) {
            return n;
        }
        if (n.isOne()) {
            return n;
        }
        if (n.isInteger()) {
            BigInteger b = Math2.sqrtExact(n.toInteger().abs());
            AwkValue x = b.signum() > 0 ? AwkInteger.valueOf(b) : AwkFloat.valueOf(Math.sqrt(Math.abs(n.toFloat())));
            return n.toFloat() > 0.0 ? x : AwkComplex.valueOf(0.0, x.toFloat());
        }
        if (n.isComplex()) {
            return AwkComplexMath.expt(n, 0.5);
        }
        if (n.toFloat() > 0.0) {
            return AwkFloat.valueOf(Math.sqrt(n.toFloat()));
        }
        return AwkComplex.valueOf(0.0, Math.sqrt(-n.toFloat()));
    }

    public static AwkValue exp(AwkValue n) {
        if (n.isComplex()) {
            double a = n.toFloat();
            double b = n.toImaginary();
            return AwkComplex.valueOf(Math.exp(a) * Math.cos(b), Math.exp(a) * Math.sin(b));
        }
        return AwkFloat.valueOf(Math.exp(n.toFloat()));
    }

    public static AwkValue log(AwkValue n) {
        if (n.isReal() && n.toFloat() > 0.0) {
            return AwkFloat.valueOf(Math.log(n.toFloat()));
        }
        double a = n.toFloat();
        double b = n.toImaginary();
        double r = Math.hypot(a, b);
        double t = Math.atan2(b, a);
        return AwkComplex.valueOf(Math.log(r), t);
    }

    public static AwkValue sin(AwkValue n) {
        if (n.isReal()) {
            return AwkFloat.valueOf(Math.sin(n.toFloat()));
        }
        if (n.toFloat() == 0.0) {
            double y = n.toImaginary();
            double b = Math.sinh(y);
            return AwkComplex.valueOf(0.0, b);
        }
        double x = n.toFloat();
        double y = n.toImaginary();
        double a = Math.sin(x) * Math.cosh(y);
        double b = Math.cos(x) * Math.sinh(y);
        return AwkComplex.valueOf(a, b);
    }

    public static AwkValue cos(AwkValue n) {
        if (n.isReal()) {
            return AwkFloat.valueOf(Math.cos(n.toFloat()));
        }
        if (n.toFloat() == 0.0) {
            double y = n.toImaginary();
            double a = Math.cosh(y);
            return AwkComplex.valueOf(a, 0.0);
        }
        double x = n.toFloat();
        double y = n.toImaginary();
        double a = Math.cos(x) * Math.cosh(y);
        double b = -(Math.sin(x) * Math.sinh(y));
        return AwkComplex.valueOf(a, b);
    }

    public static AwkValue tan(AwkValue n) {
        if (n.isReal()) {
            return AwkFloat.valueOf(Math.tan(n.toFloat()));
        }
        if (n.toFloat() == 0.0) {
            double y = n.toImaginary();
            return AwkComplex.valueOf(0.0, Math.tanh(y));
        }
        if (n.toImaginary() == Double.POSITIVE_INFINITY) {
            double x = n.toFloat();
            AwkValue nm = AwkComplex.valueOf(Math.tan(x), 1.0);
            AwkValue dn = AwkComplex.valueOf(1.0, Math.tan(x));
            return AwkValue.div(nm, dn);
        }
        if (n.toImaginary() == Double.NEGATIVE_INFINITY) {
            double x = n.toFloat();
            AwkValue nm = AwkComplex.valueOf(Math.tan(x), -1.0);
            AwkValue dn = AwkComplex.valueOf(1.0, -Math.tan(x));
            return AwkValue.div(nm, dn);
        }
        return AwkValue.div(AwkComplexMath.sin(n), AwkComplexMath.cos(n));
    }

    public static AwkValue asin(AwkValue n) {
        double x = n.toFloat();
        double y = n.toImaginary();
        if (n.isReal() && x >= -1.0 && x <= 1.0) {
            return AwkFloat.valueOf(Math.asin(n.toFloat()));
        }
        if (Double.isInfinite(x) && Double.isInfinite(y)) {
            return AwkFloat.NaN;
        }
        if (x == Double.POSITIVE_INFINITY) {
            if (y <= 0.0) {
                x = -x;
            }
            return AwkComplex.valueOf(1.5707963267948966, x);
        }
        if (x == Double.NEGATIVE_INFINITY) {
            if (y >= 0.0) {
                x = -x;
            }
            return AwkComplex.valueOf(-1.5707963267948966, x);
        }
        if (y == Double.POSITIVE_INFINITY) {
            return AwkComplex.valueOf(0.0, y);
        }
        if (y == Double.NEGATIVE_INFINITY) {
            return AwkComplex.valueOf(0.0, y);
        }
        AwkValue z1 = AwkValue.mul(I, n);
        AwkValue z2 = AwkComplexMath.sqrt(AwkValue.sub(AwkFloat.valueOf(1.0), AwkValue.mul(n, n)));
        AwkValue z3 = AwkComplexMath.log(AwkValue.add(z1, z2));
        return AwkComplex.valueOf(z3.toImaginary(), -z3.toFloat());
    }

    public static AwkValue acos(AwkValue n) {
        double x = n.toFloat();
        if (n.isReal() && x >= -1.0 && x <= 1.0) {
            return AwkFloat.valueOf(Math.acos(n.toFloat()));
        }
        AwkFloat pi2 = AwkFloat.valueOf(1.5707963267948966);
        return AwkValue.sub(pi2, AwkComplexMath.asin(n));
    }

    public static AwkValue atan(AwkValue n) {
        if (n.isReal()) {
            return AwkFloat.valueOf(Math.atan(n.toFloat()));
        }
        if (Double.isInfinite(n.toImaginary())) {
            double im = n.toImaginary();
            if (Double.isInfinite(n.toFloat())) {
                return AwkFloat.NaN;
            }
            if (im > 0.0) {
                return AwkFloat.valueOf(1.5707963267948966);
            }
            return AwkFloat.valueOf(-1.5707963267948966);
        }
        if (n.toFloat() == 0.0 && n.toImaginary() == 1.0) {
            return AwkComplex.valueOf(0.0, Double.POSITIVE_INFINITY);
        }
        if (n.toFloat() == 0.0 && n.toImaginary() == -1.0) {
            return AwkComplex.valueOf(0.0, Double.NEGATIVE_INFINITY);
        }
        AwkValue z1 = AwkValue.add(AwkFloat.valueOf(1.0), AwkValue.mul(I, n));
        AwkValue z2 = AwkValue.sub(AwkFloat.valueOf(1.0), AwkValue.mul(I, n));
        AwkValue z3 = AwkValue.sub(AwkComplexMath.log(z1), AwkComplexMath.log(z2));
        return AwkValue.div(z3, TWO_I);
    }
}

