/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.stat.dist;

import net.morilib.awk.stat.dist.AbstractDiscreteDistribution;
import net.morilib.awk.stat.dist.ContinuousDistribution;

public class ContinuousDistributionHistogram
extends AbstractDiscreteDistribution {
    private double max;
    private double min;
    private double dx;
    private ContinuousDistribution dist;

    public double cdf(double x) {
        double n = Math.floor(x);
        if (n < 0.0) {
            return 0.0;
        }
        if (n * this.dx < this.max - this.min) {
            return this.dist.cdf(n * this.dx + this.min);
        }
        return 1.0;
    }

    public double expectedValue() {
        return this.dist.expectedValue();
    }

    public double variance() {
        return this.dist.variance();
    }

    public double mode() {
        return this.dist.mode();
    }

    public double median() {
        return this.dist.median();
    }

    public double skewness() {
        return this.dist.skewness();
    }

    public double kurtosis() {
        return this.dist.kurtosis();
    }

    public double f(int n) {
        if (n < 0) {
            return 0.0;
        }
        if ((double)n * this.dx < this.max - this.min) {
            return this.dist.cdf((double)n * this.dx + this.min, (double)(n + 1) * this.dx + this.min);
        }
        return 1.0;
    }

    public boolean isInSupport(int n) {
        return n >= 0 && this.dist.isInSupport((double)n * this.dx + this.min);
    }

    public int supportMinimum() {
        return 0;
    }

    public int supportMaximum() {
        return 0x7FFFFFFE;
    }
}

