/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.stat.dist;

import net.morilib.awk.stat.dist.AbstractContinuousDistribution;

public class ExponentialDistribution
extends AbstractContinuousDistribution {
    private static final double LN2 = Math.log(2.0);
    private double lambda;

    public ExponentialDistribution(double lambda) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.lambda = lambda;
    }

    public double getLambda() {
        return this.lambda;
    }

    public double invCdf(double x) {
        if (x < 0.0 || x > 1.0) {
            return Double.NaN;
        }
        if (x == 0.0) {
            return 0.0;
        }
        if (x == 1.0) {
            return 1.0;
        }
        return -Math.log(1.0 - x) / this.lambda;
    }

    public double expectedValue() {
        return 1.0 / this.lambda;
    }

    public double variance() {
        return 1.0 / this.lambda / this.lambda;
    }

    public double mode() {
        return 0.0;
    }

    public double skewness() {
        return 2.0;
    }

    public double kurtosis() {
        return 6.0;
    }

    public double f(double x) {
        return x < 0.0 ? 0.0 : this.lambda * Math.exp(-this.lambda * x);
    }

    public boolean isInSupport(double n) {
        return n >= 0.0;
    }

    public double cdf(double x) {
        return x < 0.0 ? 0.0 : 1.0 - Math.exp(-this.lambda * x);
    }

    public double supportSupremum() {
        return Double.POSITIVE_INFINITY;
    }

    public double supportInfimum() {
        return 0.0;
    }

    public double median() {
        return LN2 / this.lambda;
    }

    public int hashCode() {
        int r = 17;
        r = 37 * (r + (int)Double.doubleToLongBits(this.lambda));
        return r;
    }

    public boolean equals(Object o) {
        if (o instanceof ExponentialDistribution) {
            ExponentialDistribution n = (ExponentialDistribution)o;
            return this.lambda == n.lambda;
        }
        return false;
    }
}

