/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.dc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.morilib.dc.DcModel;

public class DcDefaultModel
implements DcModel {
    private Map<Integer, List<Object>> registers = new HashMap<Integer, List<Object>>();
    private Map<Integer, Map<Object, Object>> arrays = new HashMap<Integer, Map<Object, Object>>();
    private BufferedReader stdrd;
    private List<Object> stack;
    private PrintStream stdout;
    private RoundingMode mode;
    private int scale;

    public DcDefaultModel(Reader rd, PrintStream out) {
        this.stdout = out;
        this.stdrd = new BufferedReader(rd);
        this.stack = new ArrayList<Object>();
        this.scale = 0;
        this.mode = RoundingMode.HALF_UP;
    }

    public DcDefaultModel(InputStream in, PrintStream out) {
        this(new InputStreamReader(in), out);
    }

    public void clear() {
        this.stack.clear();
    }

    public void duplicate() {
        this.stack.add(this.stack.get(this.stack.size() - 1));
    }

    public void exchange() {
        Object p = this.stack.remove(this.stack.size() - 1);
        Object o = this.stack.remove(this.stack.size() - 1);
        this.stack.add(p);
        this.stack.add(o);
    }

    public int getDepthOfStack() {
        return this.stack.size();
    }

    public int getInputRadix() {
        return 10;
    }

    public int getOutputRadix() {
        return 10;
    }

    public RoundingMode getRoundingMode() {
        return this.mode;
    }

    public int getScale() {
        return this.scale;
    }

    public Object peek(int c) {
        List<Object> l = this.registers.get(c);
        if (l == null || l.isEmpty()) {
            return BigDecimal.ZERO.setScale(0, this.mode);
        }
        Object o = l.get(l.size() - 1);
        if (!(o instanceof BigDecimal)) {
            return o;
        }
        if (((BigDecimal)o).scale() > this.scale) {
            return ((BigDecimal)o).setScale(this.scale, this.mode);
        }
        return o;
    }

    public Object pop() {
        return this.stack.remove(this.stack.size() - 1);
    }

    public Object pop(int c) {
        List<Object> l = this.registers.get(c);
        if (l == null || l.isEmpty()) {
            throw new EmptyStackException();
        }
        Object o = l.remove(l.size() - 1);
        if (!(o instanceof BigDecimal)) {
            return o;
        }
        if (((BigDecimal)o).scale() > this.scale) {
            return ((BigDecimal)o).setScale(this.scale, this.mode);
        }
        return o;
    }

    public void print(Object o) {
        if (o instanceof BigDecimal) {
            this.stdout.print(((BigDecimal)o).stripTrailingZeros().toPlainString());
        } else {
            this.stdout.print(o.toString());
        }
    }

    public void printAsByte(Object o) throws IOException {
        if (o instanceof BigDecimal) {
            BigDecimal d = (BigDecimal)o;
            this.stdout.write(d.toBigInteger().toByteArray());
        } else {
            this.stdout.print(o.toString());
        }
    }

    public void println(Object o) {
        this.print(o);
        this.stdout.println();
    }

    public void printStackTrace() {
        int i = this.stack.size() - 1;
        while (i >= 0) {
            this.print(this.stack.get(i));
            --i;
        }
    }

    public void push(int c, Object o) {
        List<Object> l = this.registers.get(c);
        if (l == null) {
            l = new ArrayList<Object>();
            this.registers.put(c, l);
        }
        l.add(o);
    }

    public void pushConst(int n) {
        this.push(BigDecimal.valueOf(n).setScale(0, this.mode));
    }

    public void pushNumber(String s) {
        BigDecimal d = new BigDecimal(s);
        this.push(d.setScale(d.scale(), this.mode));
    }

    public String readLine() throws IOException {
        return this.stdrd.readLine();
    }

    public void set(int c, Object o) {
        List<Object> l = this.registers.get(c);
        if (l == null || l.isEmpty()) {
            l = new ArrayList<Object>();
            l.add(o);
            this.registers.put(c, l);
        } else {
            l.set(l.size() - 1, o);
        }
    }

    public void setInputRadix(int r) {
    }

    public void setOutputRadix(int r) {
    }

    public void setRoundingMode(RoundingMode m) {
        this.mode = m;
    }

    public void setScale(int r) {
        this.scale = r;
    }

    public void execShell(String cmd) {
    }

    public void push(Object o) {
        this.stack.add(o);
    }

    public boolean isEmpty() {
        return this.stack.size() == 0;
    }

    public Object getArray(int var, Object index) {
        Object o;
        Map<Object, Object> m = this.arrays.get(var);
        if (m == null) {
            m = new HashMap<Object, Object>();
            this.arrays.put(var, m);
        }
        return (o = m.get(index)) != null ? o : BigDecimal.ZERO;
    }

    public void setArray(int var, Object index, Object v) {
        Map<Object, Object> m = this.arrays.get(var);
        if (m == null) {
            m = new HashMap<Object, Object>();
            this.arrays.put(var, m);
        }
        m.put(index, v);
    }

    public void clearArray(int var) {
        this.arrays.remove(var);
    }

    public int getArraySize(int var) {
        Map<Object, Object> m = this.arrays.get(var);
        return m == null ? 0 : m.size();
    }
}

