/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.dc;

import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import net.morilib.dc.DcCommand;
import net.morilib.dc.DcQuitSignalException;
import net.morilib.dc.DcReader;
import net.morilib.dc.DcSyntaxException;
import net.morilib.dc.DcVisitor;
import net.morilib.dc.LookaheadReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DcParser<E extends DcVisitor> {
    private Map<Character, DcCommand<E>> commands;
    private E env;

    public DcParser(Map<Character, DcCommand<E>> cmds, E env) {
        this.commands = cmds;
        this.env = env;
    }

    void debug(int c) {
        if (c < 256 || Character.isLetterOrDigit(c)) {
            System.out.print((char)c);
        } else {
            System.out.print(c);
        }
    }

    void parse(Reader reader, boolean tail) throws IOException {
        StringBuffer b = null;
        S1 stat = S1.INIT;
        int cnt = 0;
        DcReader rd = new DcReader(new LookaheadReader(reader, 1));
        while (true) {
            int c = rd.read();
            switch (stat) {
                case INIT: {
                    if (c < 0) {
                        return;
                    }
                    if (c == 91) {
                        b = new StringBuffer();
                        ++cnt;
                        stat = S1.STR1;
                        break;
                    }
                    if (c == 95) {
                        b = new StringBuffer();
                        b.append('-');
                        stat = S1.MINS;
                        break;
                    }
                    if (c >= 48 && c <= 57 || c >= 65 && c <= 70) {
                        b = new StringBuffer();
                        b.append((char)c);
                        stat = S1.NUM1;
                        break;
                    }
                    if (c == 46) {
                        b = new StringBuffer();
                        b.append('0').append('.');
                        stat = S1.NUM2;
                        break;
                    }
                    if (c == 33) {
                        stat = S1.XCL1;
                        break;
                    }
                    if (c == 35) {
                        stat = S1.COMT;
                        break;
                    }
                    if (Character.isWhitespace(c) || !this.commands.containsKey(Character.valueOf((char)c))) break;
                    this.commands.get(Character.valueOf((char)c)).parse(this, this.env, rd, tail);
                    break;
                }
                case STR1: {
                    if (c < 0) {
                        throw new DcSyntaxException();
                    }
                    if (c == 93 && --cnt == 0) {
                        this.env.push(b.toString());
                        stat = S1.INIT;
                        break;
                    }
                    b.append((char)c);
                    if (c != 91) break;
                    ++cnt;
                    break;
                }
                case MINS: {
                    if (c < 0) {
                        throw new DcSyntaxException();
                    }
                    if (c >= 48 && c <= 57 || c >= 65 && c <= 70) {
                        b.append((char)c);
                        stat = S1.NUM1;
                        break;
                    }
                    if (c == 46) {
                        b.append('0').append('.');
                        stat = S1.NUM2;
                        break;
                    }
                    throw new DcSyntaxException();
                }
                case NUM1: {
                    if (c < 0) {
                        this.env.pushNumber(b.toString());
                        return;
                    }
                    if (c >= 48 && c <= 57 || c >= 65 && c <= 70) {
                        b.append((char)c);
                        break;
                    }
                    if (c == 46) {
                        b.append('.');
                        stat = S1.NUM2;
                        break;
                    }
                    if (c == 33) {
                        this.env.pushNumber(b.toString());
                        stat = S1.XCL1;
                        break;
                    }
                    if (c == 35) {
                        this.env.pushNumber(b.toString());
                        stat = S1.COMT;
                        break;
                    }
                    if (Character.isWhitespace(c)) {
                        this.env.pushNumber(b.toString());
                        stat = S1.INIT;
                        break;
                    }
                    if (!this.commands.containsKey(Character.valueOf((char)c))) break;
                    this.env.pushNumber(b.toString());
                    this.commands.get(Character.valueOf((char)c)).parse(this, this.env, rd, tail);
                    stat = S1.INIT;
                    break;
                }
                case NUM2: {
                    if (c < 0) {
                        this.env.pushNumber(b.toString());
                        return;
                    }
                    if (c >= 48 && c <= 57 || c >= 65 && c <= 70) {
                        b.append((char)c);
                        break;
                    }
                    if (c == 33) {
                        this.env.pushNumber(b.toString());
                        stat = S1.XCL1;
                        break;
                    }
                    if (c == 35) {
                        this.env.pushNumber(b.toString());
                        stat = S1.COMT;
                        break;
                    }
                    if (Character.isWhitespace(c)) {
                        this.env.pushNumber(b.toString());
                        stat = S1.INIT;
                        break;
                    }
                    if (!this.commands.containsKey(Character.valueOf((char)c))) break;
                    this.env.pushNumber(b.toString());
                    this.commands.get(Character.valueOf((char)c)).parse(this, this.env, rd, tail);
                    stat = S1.INIT;
                    break;
                }
                case XCL1: {
                    if (c < 0) {
                        return;
                    }
                    if (c == 60) {
                        this.commands.get(Character.valueOf('\u5927')).parse(this, this.env, rd, tail);
                        stat = S1.INIT;
                        break;
                    }
                    if (c == 62) {
                        this.commands.get(Character.valueOf('\u5c0f')).parse(this, this.env, rd, tail);
                        stat = S1.INIT;
                        break;
                    }
                    if (c == 61) {
                        this.commands.get(Character.valueOf('\u4e0d')).parse(this, this.env, rd, tail);
                        stat = S1.INIT;
                        break;
                    }
                    if (c == 10) {
                        stat = S1.INIT;
                        break;
                    }
                    b = new StringBuffer();
                    b.append((char)c);
                    stat = S1.XCL2;
                    break;
                }
                case XCL2: {
                    if (c < 0) {
                        this.env.execShell(b.toString());
                        break;
                    }
                    if (c != 10) break;
                    this.env.execShell(b.toString());
                    stat = S1.INIT;
                    break;
                }
                case COMT: {
                    if (c < 0) {
                        return;
                    }
                    if (c != 10) break;
                    stat = S1.INIT;
                }
            }
        }
    }

    public void parse(Reader reader) throws IOException {
        try {
            this.parse(reader, true);
        }
        catch (DcQuitSignalException dcQuitSignalException) {
            // empty catch block
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum S1 {
        INIT,
        STR1,
        MINS,
        NUM1,
        NUM2,
        XCL1,
        XCL2,
        COMT;

    }
}

