/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sed;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.List;
import net.morilib.sed.SedCommandBundle;
import net.morilib.sed.SedCommandLine;
import net.morilib.sed.SedEngine;
import net.morilib.sed.SedParser;
import net.morilib.sed.SedPatternEngine;
import net.morilib.sh.ShFileSystem;

public class Sed {
    public static int execute(ShFileSystem fs, SedCommandBundle b, Reader command, Reader reader, PrintStream writer, SedPatternEngine engine, boolean display) throws IOException {
        List<SedCommandLine> cmds = SedParser.parse(b, command);
        return SedEngine.execute(fs, reader, writer, engine, display, cmds.toArray(new SedCommandLine[0]));
    }

    public static int execute(ShFileSystem fs, SedCommandBundle b, String command, Reader reader, PrintStream writer, SedPatternEngine engine, boolean display) throws IOException {
        return Sed.execute(fs, b, new StringReader(command), reader, writer, engine, display);
    }

    public static int execute(ShFileSystem fs, Reader command, Reader reader, PrintStream writer, SedPatternEngine engine, boolean display) throws IOException {
        return Sed.execute(fs, SedCommandBundle.newInstance(), command, reader, writer, engine, display);
    }

    public static int execute(ShFileSystem fs, String command, Reader reader, PrintStream writer, SedPatternEngine engine, boolean display) throws IOException {
        return Sed.execute(fs, SedCommandBundle.newInstance(), new StringReader(command), reader, writer, engine, display);
    }

    public static String execute(ShFileSystem fs, SedCommandBundle b, String command, String input, Charset outputEncoding, SedPatternEngine engine, boolean display) throws IOException {
        ByteArrayOutputStream ous = new ByteArrayOutputStream();
        StringReader rd = new StringReader(input);
        PrintStream wr = new PrintStream(ous);
        Sed.execute(fs, b, command, (Reader)rd, wr, engine, display);
        return new String(ous.toByteArray(), outputEncoding);
    }

    public static String execute(ShFileSystem fs, SedCommandBundle b, String command, String input, String outputEncoding, SedPatternEngine engine, boolean display) throws IOException {
        return Sed.execute(fs, b, command, input, Charset.forName(outputEncoding), engine, display);
    }
}

